/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class ContentType {
    private static final Set<String> BINARY_TYPES = new HashSet<String>();
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", StandardCharsets.UTF_8);
    public static final ContentType APPLICATION_JSON_PATCH = ContentType.create("application/json-patch+json");
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", true);
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", StandardCharsets.ISO_8859_1);
    public static final ContentType APPLICATION_PDF = ContentType.create("application/pdf", true);
    public static final ContentType IMAGE_BMP = ContentType.create("image/bmp", true);
    public static final ContentType IMAGE_GIF = ContentType.create("image/gif", true);
    public static final ContentType IMAGE_JPEG = ContentType.create("image/jpeg", true);
    public static final ContentType IMAGE_PNG = ContentType.create("image/png", true);
    public static final ContentType IMAGE_SVG = ContentType.create("image/svg+xml");
    public static final ContentType IMAGE_TIFF = ContentType.create("image/tiff", true);
    public static final ContentType IMAGE_WEBP = ContentType.create("image/webp", true);
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", StandardCharsets.ISO_8859_1);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", StandardCharsets.ISO_8859_1);
    public static final ContentType WILDCARD = ContentType.create("*/*");
    private final String mimeType;
    private final Charset encoding;
    private final boolean isBinary;

    public static ContentType create(String mimeType) {
        return new ContentType(mimeType, null, false);
    }

    public static ContentType create(String mimeType, Charset charset) {
        return new ContentType(mimeType, charset, false);
    }

    public static ContentType create(String mimeType, boolean isBinary) {
        return new ContentType(mimeType, null, isBinary);
    }

    ContentType(String mimeType, Charset encoding, boolean isBinary) {
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.isBinary = isBinary;
        if (isBinary && !BINARY_TYPES.contains(mimeType)) {
            BINARY_TYPES.add(mimeType);
        }
    }

    public static boolean isBinary(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return BINARY_TYPES.contains(mimeType.toLowerCase());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.mimeType);
        if (this.encoding != null) {
            sb.append("; charset=").append(this.encoding);
        }
        return sb.toString();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public ContentType withCharset(Charset charset) {
        return new ContentType(this.mimeType, charset, this.isBinary);
    }

    public boolean isBinary() {
        return this.isBinary;
    }
}

