/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks.player;

import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.player.AbstractPlayerTask;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import org.bukkit.GameMode;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;

public class InfusedMagnetTask
extends AbstractPlayerTask {
    private final double radius;

    public InfusedMagnetTask(@Nonnull Player p, double radius) {
        super(p);
        this.radius = radius;
    }

    @Override
    protected void executeTask() {
        boolean playSound = false;
        for (Entity entity : this.p.getNearbyEntities(this.radius, this.radius, this.radius)) {
            Item item;
            if (!(entity instanceof Item) || SlimefunUtils.hasNoPickupFlag(item = (Item)entity) || item.getPickupDelay() > 0 || !(this.p.getLocation().distanceSquared(item.getLocation()) > 0.3)) continue;
            item.teleport(this.p.getLocation());
            playSound = true;
        }
        if (playSound) {
            SoundEffect.INFUSED_MAGNET_TELEPORT_SOUND.playFor(this.p);
        }
    }

    @Override
    protected boolean isValid() {
        return super.isValid() && this.p.getGameMode() != GameMode.SPECTATOR;
    }
}

