/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.WitherProof;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ExplosionsListener
implements Listener {
    public ExplosionsListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent e) {
        this.removeResistantBlocks(e.blockList().iterator());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent e) {
        this.removeResistantBlocks(e.blockList().iterator());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityBreak(EntityChangeBlockEvent e) {
        if (e.getEntity().getType() == EntityType.WITHER || e.getEntity().getType() == EntityType.WITHER_SKULL) {
            this.removeResistantBlock(e.getBlock());
        }
    }

    private void removeResistantBlocks(@Nonnull Iterator<Block> blocks) {
        while (blocks.hasNext()) {
            Block block = blocks.next();
            SlimefunItem item = BlockStorage.check(block);
            if (item == null) continue;
            blocks.remove();
            this.removeResistantBlock(block, item);
        }
    }

    private void removeResistantBlock(@Nonnull Block block) {
        SlimefunItem slimefunItem = BlockStorage.check(block);
        if (slimefunItem != null) {
            this.removeResistantBlock(block, slimefunItem);
        }
    }

    private void removeResistantBlock(@Nonnull Block block, @Nonnull SlimefunItem slimefunItem) {
        if (!(slimefunItem instanceof WitherProof) && !slimefunItem.callItemHandler(BlockBreakHandler.class, handler -> this.handleExplosion((BlockBreakHandler)handler, block))) {
            BlockStorage.clearBlockInfo(block);
            block.setType(Material.AIR);
        }
    }

    @ParametersAreNonnullByDefault
    private void handleExplosion(BlockBreakHandler handler, Block block) {
        if (handler.isExplosionAllowed(block)) {
            BlockStorage.clearBlockInfo(block);
            block.setType(Material.AIR);
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            handler.onExplode(block, drops);
            for (ItemStack drop : drops) {
                if (drop == null || drop.getType().isAir()) continue;
                block.getWorld().dropItemNaturally(block.getLocation(), drop);
            }
        }
    }
}

