/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.VanillaInventoryDropHandler;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dropper;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class IgnitionChamber
extends SlimefunItem {
    private static final BlockFace[] ADJACENT_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};

    @ParametersAreNonnullByDefault
    public IgnitionChamber(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
        this.addItemHandler(new VanillaInventoryDropHandler<Dropper>(Dropper.class));
    }

    @ParametersAreNonnullByDefault
    public static boolean useFlintAndSteel(Player p, Block smelteryBlock) {
        Validate.notNull(p, "The Player must not be null!");
        Validate.notNull(smelteryBlock, "The smeltery block cannot be null!");
        Inventory inv = IgnitionChamber.findIgnitionChamber(smelteryBlock);
        if (inv == null) {
            return false;
        }
        if (inv.contains(Material.FLINT_AND_STEEL)) {
            ItemStack item = inv.getItem(inv.first(Material.FLINT_AND_STEEL));
            ItemMeta meta = item.getItemMeta();
            if (!meta.isUnbreakable()) {
                ((Damageable)meta).setDamage(((Damageable)meta).getDamage() + 1);
                if (((Damageable)meta).getDamage() >= item.getType().getMaxDurability()) {
                    item.setAmount(0);
                    SoundEffect.IGNITION_CHAMBER_USE_FLINT_AND_STEEL_SOUND.playAt(smelteryBlock);
                } else {
                    item.setItemMeta(meta);
                }
            }
            SoundEffect.IGNITION_CHAMBER_USE_FLINT_AND_STEEL_SOUND.playAt(smelteryBlock);
            return true;
        }
        Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.ignition-chamber-no-flint", true);
        return false;
    }

    @Nullable
    private static Inventory findIgnitionChamber(@Nonnull Block b) {
        for (BlockFace face : ADJACENT_FACES) {
            BlockState state;
            Block block = b.getRelative(face);
            if (block.getType() != Material.DROPPER || !(BlockStorage.check(block) instanceof IgnitionChamber) || !((state = PaperLib.getBlockState(b.getRelative(face), false).getState()) instanceof Dropper)) continue;
            Dropper dropper = (Dropper)state;
            return dropper.getInventory();
        }
        return null;
    }
}

