/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler.inspectors;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceInspector;
import io.github.thebusybiscuit.slimefun4.core.services.profiler.SummaryOrderType;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerPerformanceInspector
implements PerformanceInspector {
    private final UUID uuid;
    private final SummaryOrderType orderType;

    public PlayerPerformanceInspector(@Nonnull Player player, @Nonnull SummaryOrderType orderType) {
        Validate.notNull(player, "Player cannot be null");
        Validate.notNull((Object)orderType, "SummaryOrderType cannot be null");
        this.uuid = player.getUniqueId();
        this.orderType = orderType;
    }

    @Nullable
    private Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Override
    public boolean isValid() {
        Player player = this.getPlayer();
        return player != null && player.isOnline();
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    @Override
    @Nonnull
    public SummaryOrderType getOrderType() {
        return this.orderType;
    }

    @Override
    public void sendMessage(@Nonnull String msg) {
        Player player = this.getPlayer();
        if (player != null) {
            player.sendMessage(msg);
        }
    }

    public void sendMessage(@Nonnull TextComponent component) {
        Player player = this.getPlayer();
        if (player != null) {
            player.spigot().sendMessage((BaseComponent)component);
        }
    }
}

