/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.debug;

import io.github.thebusybiscuit.slimefun4.core.debug.TestCase;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Debug {
    private static String testCase = null;

    private Debug() {
    }

    public static void log(@Nonnull TestCase testCase, @Nonnull String msg) {
        Debug.log(testCase.toString(), msg, new Object[0]);
    }

    public static void log(@Nonnull TestCase testCase, @Nonnull String msg, Object ... vars) {
        Debug.log(testCase.toString(), msg, vars);
    }

    public static void log(@Nonnull String test, @Nonnull String msg) {
        Debug.log(test, msg, new Object[0]);
    }

    public static void log(@Nonnull String test, @Nonnull String msg, Object ... vars) {
        if (testCase == null || !testCase.equals(test)) {
            return;
        }
        if (vars.length > 0) {
            String formatted = Debug.formatMessage(msg, vars);
            Slimefun.logger().log(Level.INFO, "[DEBUG {0}] {1}", new Object[]{test, formatted});
        } else {
            Slimefun.logger().log(Level.INFO, "[DEBUG {0}] {1}", new Object[]{test, msg});
        }
    }

    @Nonnull
    private static String formatMessage(@Nonnull String msg, Object ... vars) {
        int i = 0;
        int idx = 0;
        while ((i = ((String)msg).indexOf(123, i)) != -1 && ((String)msg).charAt(i + 1) == '}') {
            msg = ((String)msg).substring(0, i) + vars[idx] + ((String)msg).substring(i + 2);
            i += String.valueOf(vars[idx++]).length();
        }
        return msg;
    }

    public static void setTestCase(@Nullable String test) {
        testCase = test;
    }

    @Nullable
    public static String getTestCase() {
        return testCase;
    }
}

