/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.protection.modules;

import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ActionType;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import javax.annotation.Nonnull;
import me.angeschossen.chestprotect.api.ChestProtectAPI;
import me.angeschossen.chestprotect.api.protection.block.BlockProtection;
import me.angeschossen.chestprotect.api.protection.world.ProtectionWorld;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class ChestProtectProtectionModule
implements ProtectionModule {
    private final Plugin plugin;
    private ChestProtectAPI api;

    public ChestProtectProtectionModule(@Nonnull Plugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.api = ChestProtectAPI.getInstance();
    }

    @Override
    public boolean hasPermission(OfflinePlayer p, Location l, Interaction action) {
        if (action.getType() != ActionType.BLOCK || !this.api.getProtectionManager().isProtectableBlock(l.getBlock().getType())) {
            return true;
        }
        ProtectionWorld world = this.api.getProtectionWorld(l.getWorld());
        if (world == null) {
            return true;
        }
        BlockProtection protection = world.getBlockProtection(l.getBlockX(), l.getBlockY(), l.getBlockZ());
        return protection == null || protection.isTrusted(p.getUniqueId());
    }
}

