/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.AbstractItemNetwork;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoNetworkTask;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.CommonPatterns;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class CargoNet
extends AbstractItemNetwork
implements HologramOwner {
    private static final int RANGE = 5;
    private static final int TICK_DELAY = Slimefun.getCfg().getInt("networks.cargo-ticker-delay");
    private final Set<Location> inputNodes = new HashSet<Location>();
    private final Set<Location> outputNodes = new HashSet<Location>();
    protected final Map<Location, Integer> roundRobin = new HashMap<Location, Integer>();
    private int tickDelayThreshold = 0;

    @Nullable
    public static CargoNet getNetworkFromLocation(@Nonnull Location l) {
        return Slimefun.getNetworkManager().getNetworkFromLocation(l, CargoNet.class).orElse(null);
    }

    @Nonnull
    public static CargoNet getNetworkFromLocationOrCreate(@Nonnull Location l) {
        Optional<CargoNet> cargoNetwork = Slimefun.getNetworkManager().getNetworkFromLocation(l, CargoNet.class);
        if (cargoNetwork.isPresent()) {
            return cargoNetwork.get();
        }
        CargoNet network = new CargoNet(l);
        Slimefun.getNetworkManager().registerNetwork(network);
        return network;
    }

    protected CargoNet(@Nonnull Location l) {
        super(l);
    }

    @Override
    public String getId() {
        return "CARGO_NETWORK";
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public NetworkComponent classifyLocation(@Nonnull Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        return switch (id) {
            case "CARGO_MANAGER" -> NetworkComponent.REGULATOR;
            case "CARGO_NODE" -> NetworkComponent.CONNECTOR;
            case "CARGO_NODE_INPUT", "CARGO_NODE_OUTPUT", "CARGO_NODE_OUTPUT_ADVANCED" -> NetworkComponent.TERMINUS;
            default -> null;
        };
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        this.connectorCache.remove(l);
        if (from == NetworkComponent.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
        }
        if (to == NetworkComponent.TERMINUS) {
            String id;
            switch (id = BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": 
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.outputNodes.add(l);
                    break;
                }
            }
        }
    }

    public void tick(@Nonnull Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            this.updateHologram(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            this.updateHologram(b, "&cNo Cargo Nodes found");
        } else {
            this.updateHologram(b, "&7Status: &a&lONLINE");
            if (this.tickDelayThreshold < TICK_DELAY) {
                ++this.tickDelayThreshold;
                return;
            }
            this.tickDelayThreshold = 0;
            Map<Location, Integer> inputs = this.mapInputNodes();
            Map<Integer, List<Location>> outputs = this.mapOutputNodes();
            if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
                this.display();
            }
            Slimefun.getProfiler().scheduleEntries(inputs.size() + 1);
            CargoNetworkTask runnable = new CargoNetworkTask(this, inputs, outputs);
            Slimefun.runSync(runnable);
        }
    }

    @Nonnull
    private Map<Location, Integer> mapInputNodes() {
        HashMap<Location, Integer> inputs = new HashMap<Location, Integer>();
        for (Location node : this.inputNodes) {
            int frequency = CargoNet.getFrequency(node);
            if (frequency < 0 || frequency >= 16) continue;
            inputs.put(node, frequency);
        }
        return inputs;
    }

    @Nonnull
    private Map<Integer, List<Location>> mapOutputNodes() {
        HashMap<Integer, List<Location>> output = new HashMap<Integer, List<Location>>();
        LinkedList<Location> list = new LinkedList<Location>();
        int lastFrequency = -1;
        for (Location node : this.outputNodes) {
            int frequency = CargoNet.getFrequency(node);
            if (frequency != lastFrequency && lastFrequency != -1) {
                output.merge(lastFrequency, list, (prev, next) -> {
                    prev.addAll(next);
                    return prev;
                });
                list = new LinkedList();
            }
            list.add(node);
            lastFrequency = frequency;
        }
        if (!list.isEmpty()) {
            output.merge(lastFrequency, list, (prev, next) -> {
                prev.addAll(next);
                return prev;
            });
        }
        return output;
    }

    private static int getFrequency(@Nonnull Location node) {
        String frequency = BlockStorage.getLocationInfo(node, "frequency");
        if (frequency == null) {
            return 0;
        }
        if (!CommonPatterns.NUMERIC.matcher(frequency).matches()) {
            Slimefun.logger().log(Level.SEVERE, () -> "Failed to parse a Cargo Node Frequency (" + node.getWorld().getName() + " - " + node.getBlockX() + "," + node.getBlockY() + "," + node.getBlockZ() + "): " + frequency);
            return 0;
        }
        return Integer.parseInt(frequency);
    }
}

