/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.services.sounds.SoundEffect;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.AbstractCraftingTable;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ArmorForge
extends AbstractCraftingTable {
    @ParametersAreNonnullByDefault
    public ArmorForge(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, new ItemStack[]{null, null, null, null, new ItemStack(Material.ANVIL), null, null, new CustomItemStack(Material.DISPENSER, "Dispenser (Facing up)", new String[0]), null}, BlockFace.SELF);
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block possibleDispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(possibleDispenser, false).getState();
        if (state instanceof Dispenser) {
            Dispenser dispenser = (Dispenser)state;
            Inventory inv = dispenser.getInventory();
            List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
            for (ItemStack[] input : inputs) {
                if (!this.isCraftable(inv, input)) continue;
                ItemStack output = RecipeType.getRecipeOutputList(this, input).clone();
                if (SlimefunUtils.canPlayerUseItem(p, output, true)) {
                    this.craft(p, output, inv, possibleDispenser);
                }
                return;
            }
            if (inv.isEmpty()) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.inventory-empty", true);
            } else {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
            }
        }
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], true)) continue;
            return false;
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    private void craft(Player p, ItemStack output, Inventory inv, Block dispenser) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            int j;
            for (j = 0; j < 9; ++j) {
                ItemStack item = inv.getContents()[j];
                if (item == null || item.getType() == Material.AIR) continue;
                ItemUtils.consumeItem(item, true);
            }
            for (j = 0; j < 4; ++j) {
                int current = j;
                Slimefun.runSync(() -> {
                    if (current < 3) {
                        SoundEffect.ARMOR_FORGE_WORKING_SOUND.playAt(dispenser);
                    } else {
                        SoundEffect.ARMOR_FORGE_FINISH_SOUND.playAt(dispenser);
                        this.handleCraftedItem(output, dispenser, inv);
                    }
                }, (long)j * 20L);
            }
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }
}

