/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.multiblocks;

import com.google.common.base.Preconditions;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSpawnReason;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.MultiBlockInteractionHandler;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.OutputChest;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class MultiBlockMachine
extends SlimefunItem
implements NotPlaceable,
RecipeDisplayItem {
    protected final List<ItemStack[]> recipes = new ArrayList<ItemStack[]>();
    protected final List<ItemStack> displayRecipes = new ArrayList<ItemStack>();
    protected final MultiBlock multiblock;

    @ParametersAreNonnullByDefault
    protected MultiBlockMachine(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, ItemStack[] machineRecipes, BlockFace trigger) {
        super(itemGroup, item, RecipeType.MULTIBLOCK, recipe);
        this.displayRecipes.addAll(Arrays.asList(machineRecipes));
        this.multiblock = new MultiBlock(this, MultiBlockMachine.convertItemStacksToMaterial(recipe), trigger);
        this.registerDefaultRecipes(this.displayRecipes);
    }

    @ParametersAreNonnullByDefault
    protected MultiBlockMachine(ItemGroup itemGroup, SlimefunItemStack item, ItemStack[] recipe, BlockFace trigger) {
        this(itemGroup, item, recipe, new ItemStack[0], trigger);
    }

    protected void registerDefaultRecipes(@Nonnull List<ItemStack> recipes) {
    }

    @Nonnull
    public List<ItemStack[]> getRecipes() {
        return this.recipes;
    }

    @Override
    @Nonnull
    public List<ItemStack> getDisplayRecipes() {
        return this.displayRecipes;
    }

    @Nonnull
    public MultiBlock getMultiBlock() {
        return this.multiblock;
    }

    public void addRecipe(ItemStack[] input, ItemStack output) {
        Validate.notNull(output, "Recipes must have an Output!");
        this.recipes.add(input);
        this.recipes.add(new ItemStack[]{output});
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        this.addItemHandler(this.getInteractionHandler());
        super.register(addon);
    }

    @Override
    public void postRegister() {
        Slimefun.getRegistry().getMultiBlocks().add(this.multiblock);
    }

    @Override
    public void load() {
        super.load();
        Preconditions.checkArgument((this.displayRecipes.size() % 2 == 0 ? 1 : 0) != 0, (Object)"This MultiBlockMachine's display recipes were illegally modified!");
        for (int i = 0; i < this.displayRecipes.size(); i += 2) {
            ItemStack inputStack = this.displayRecipes.get(i);
            ItemStack outputStack = null;
            if (this.displayRecipes.size() >= i + 2) {
                outputStack = this.displayRecipes.get(i + 1);
            }
            SlimefunItem inputItem = SlimefunItem.getByItem(inputStack);
            SlimefunItem outputItem = SlimefunItem.getByItem(outputStack);
            if (inputItem != null && inputItem.isDisabled() || outputItem != null && outputItem.isDisabled()) continue;
            this.recipes.add(new ItemStack[]{inputStack});
            this.recipes.add(new ItemStack[]{outputStack});
        }
    }

    @Nonnull
    protected MultiBlockInteractionHandler getInteractionHandler() {
        return (p, mb, b) -> {
            if (mb.equals(this.getMultiBlock())) {
                if (this.canUse(p, true) && Slimefun.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), Interaction.INTERACT_BLOCK)) {
                    this.onInteract(p, b);
                }
                return true;
            }
            return false;
        };
    }

    public abstract void onInteract(Player var1, Block var2);

    @ParametersAreNonnullByDefault
    @Nullable
    protected Inventory findOutputInventory(ItemStack adding, Block dispBlock, Inventory dispInv) {
        return this.findOutputInventory(adding, dispBlock, dispInv, dispInv);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    protected Inventory findOutputInventory(ItemStack product, Block dispBlock, Inventory dispInv, Inventory placeCheckerInv) {
        Optional<Inventory> outputChest = OutputChest.findOutputChestFor(dispBlock, product);
        if (!outputChest.isPresent() && InvUtils.fits(placeCheckerInv, product, new int[0])) {
            return dispInv;
        }
        return outputChest.orElse(null);
    }

    @ParametersAreNonnullByDefault
    protected void handleCraftedItem(ItemStack outputItem, Block block, Inventory blockInv) {
        Inventory outputInv = this.findOutputInventory(outputItem, block, blockInv);
        if (outputInv != null) {
            outputInv.addItem(new ItemStack[]{outputItem});
        } else {
            ItemStack rest = (ItemStack)blockInv.addItem(new ItemStack[]{outputItem}).get(0);
            if (rest != null) {
                SlimefunUtils.spawnItem(block.getLocation(), rest, ItemSpawnReason.MULTIBLOCK_MACHINE_OVERFLOW, true);
            }
        }
    }

    @Nonnull
    private static Material[] convertItemStacksToMaterial(@Nonnull ItemStack[] items) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (ItemStack item : items) {
            if (item == null) {
                materials.add(null);
                continue;
            }
            if (item.getType() == Material.FLINT_AND_STEEL) {
                materials.add(Material.FIRE);
                continue;
            }
            materials.add(item.getType());
        }
        return materials.toArray(new Material[0]);
    }
}

