/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.versions;

import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.IncomparableVersionsException;
import io.github.thebusybiscuit.slimefun4.libraries.dough.versions.Version;
import javax.annotation.Nonnull;

abstract class AbstractNumericVersion
implements Version {
    private final int versionNumber;

    AbstractNumericVersion(int version) {
        Validate.isTrue(version > 0, "The version must be a positive number.");
        this.versionNumber = version;
    }

    public final int getVersionNumber() {
        return this.versionNumber;
    }

    @Override
    public boolean isSimilar(Version version) {
        return version instanceof AbstractNumericVersion;
    }

    @Override
    public boolean isNewerThan(@Nonnull Version version) {
        if (this.isSimilar(version)) {
            return this.getVersionNumber() > ((AbstractNumericVersion)version).getVersionNumber();
        }
        throw new IncomparableVersionsException(this, version);
    }

    @Override
    public boolean isEqualTo(@Nonnull Version version) {
        if (this.isSimilar(version)) {
            return this.getVersionNumber() == ((AbstractNumericVersion)version).getVersionNumber();
        }
        throw new IncomparableVersionsException(this, version);
    }

    @Override
    public boolean isOlderThan(@Nonnull Version version) {
        if (this.isSimilar(version)) {
            return this.getVersionNumber() < ((AbstractNumericVersion)version).getVersionNumber();
        }
        throw new IncomparableVersionsException(this, version);
    }
}

