/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.EnhancedFurnace;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.Optional;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.Furnace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EnhancedFurnaceListener
implements Listener {
    public EnhancedFurnaceListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFuelBurn(FurnaceBurnEvent e) {
        EnhancedFurnace enhancedFurnace;
        if (e.getBlock().getType() != Material.FURNACE) {
            return;
        }
        SlimefunItem furnace = BlockStorage.check(e.getBlock());
        if (furnace instanceof EnhancedFurnace && (enhancedFurnace = (EnhancedFurnace)furnace).getFuelEfficiency() > 0) {
            int burnTime = e.getBurnTime();
            int newBurnTime = enhancedFurnace.getFuelEfficiency() * burnTime;
            e.setBurnTime(Math.min(newBurnTime, 32766));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemSmelt(FurnaceSmeltEvent e) {
        if (e.getBlock().getType() != Material.FURNACE) {
            return;
        }
        SlimefunItem sfItem = BlockStorage.check(e.getBlock());
        if (sfItem instanceof EnhancedFurnace) {
            EnhancedFurnace enhancedFurnace = (EnhancedFurnace)sfItem;
            BlockState state = PaperLib.getBlockState(e.getBlock(), false).getState();
            if (state instanceof Furnace) {
                Furnace furnace = (Furnace)state;
                FurnaceInventory inventory = furnace.getInventory();
                if (inventory.getSmelting() == null) {
                    return;
                }
                boolean multiplier = SlimefunTag.ENHANCED_FURNACE_LUCK_MATERIALS.isTagged(inventory.getSmelting().getType());
                int amount = multiplier ? enhancedFurnace.getRandomOutputAmount() : 1;
                Optional<ItemStack> result = Slimefun.getMinecraftRecipeService().getFurnaceOutput(inventory.getSmelting());
                if (result.isPresent()) {
                    ItemStack item = result.get();
                    int previous = inventory.getResult() != null ? inventory.getResult().getAmount() : 0;
                    amount = Math.min(item.getMaxStackSize() - previous, amount);
                    e.setResult(new ItemStack(item.getType(), amount));
                }
            }
        }
    }
}

