/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.collections.OptionalMap;
import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class PerWorldSettingsService {
    private final Slimefun plugin;
    private final OptionalMap<UUID, Set<String>> disabledItems = new OptionalMap(HashMap::new);
    private final Map<SlimefunAddon, Set<String>> disabledAddons = new HashMap<SlimefunAddon, Set<String>>();
    private final Set<UUID> disabledWorlds = new HashSet<UUID>();

    public PerWorldSettingsService(@Nonnull Slimefun plugin) {
        this.plugin = plugin;
    }

    public void load(@Nonnull Iterable<World> worlds) {
        for (World world : worlds) {
            this.load(world);
        }
    }

    public void load(@Nonnull World world) {
        Validate.notNull(world, "Cannot load a world that is null");
        this.disabledItems.putIfAbsent(world.getUID(), this.loadWorldFromConfig(world));
    }

    public boolean isEnabled(@Nonnull World world, @Nonnull SlimefunItem item) {
        Validate.notNull(world, "The world cannot be null");
        Validate.notNull(item, "The SlimefunItem cannot be null");
        Set items = this.disabledItems.computeIfAbsent(world.getUID(), id -> this.loadWorldFromConfig(world));
        if (this.disabledWorlds.contains(world.getUID())) {
            return false;
        }
        return !items.contains(item.getId());
    }

    public void setEnabled(@Nonnull World world, @Nonnull SlimefunItem item, boolean enabled) {
        Validate.notNull(world, "The world cannot be null");
        Validate.notNull(item, "The SlimefunItem cannot be null");
        Set items = this.disabledItems.computeIfAbsent(world.getUID(), id -> this.loadWorldFromConfig(world));
        if (enabled) {
            items.remove(item.getId());
        } else {
            items.add(item.getId());
        }
    }

    public void setEnabled(@Nonnull World world, boolean enabled) {
        Validate.notNull(world, "null is not a valid World");
        this.load(world);
        if (enabled) {
            this.disabledWorlds.remove(world.getUID());
        } else {
            this.disabledWorlds.add(world.getUID());
        }
    }

    public boolean isWorldEnabled(@Nonnull World world) {
        Validate.notNull(world, "null is not a valid World");
        this.load(world);
        return !this.disabledWorlds.contains(world.getUID());
    }

    public boolean isAddonEnabled(@Nonnull World world, @Nonnull SlimefunAddon addon) {
        Validate.notNull(world, "World cannot be null");
        Validate.notNull(addon, "Addon cannot be null");
        return this.isWorldEnabled(world) && this.disabledAddons.getOrDefault(addon, Collections.emptySet()).contains(world.getName());
    }

    public void save(@Nonnull World world) {
        Validate.notNull(world, "Cannot save a World that does not exist");
        Set items = this.disabledItems.computeIfAbsent(world.getUID(), id -> this.loadWorldFromConfig(world));
        Config config = this.getConfig(world);
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (item == null) continue;
            String addon = item.getAddon().getName().toLowerCase(Locale.ROOT);
            config.setValue(addon + "." + item.getId(), !items.contains(item.getId()));
        }
        config.save();
    }

    @Nonnull
    private Set<String> loadWorldFromConfig(@Nonnull World world) {
        Validate.notNull(world, "Cannot load a World that does not exist");
        String name = world.getName();
        Optional<Set<String>> optional = this.disabledItems.get(world.getUID());
        if (optional.isPresent()) {
            return optional.get();
        }
        LinkedHashSet<String> items = new LinkedHashSet<String>();
        Config config = this.getConfig(world);
        config.getConfiguration().options().header("This file is used to disable certain items in a particular world.\nYou can set any item to 'false' to disable it in the world '" + name + "'.\nYou can also disable an entire addon from Slimefun by setting the respective\nvalue of 'enabled' for that Addon.\n\nItems which are disabled in this world will not show up in the Slimefun Guide.\nYou won't be able to use these items either. Using them will result in a warning message.");
        config.getConfiguration().options().copyHeader(true);
        config.setDefaultValue("enabled", true);
        if (config.getBoolean("enabled")) {
            this.loadItemsFromWorldConfig(name, config, items);
            if (Slimefun.getMinecraftVersion() != MinecraftVersion.UNIT_TEST) {
                config.save();
            }
        } else {
            this.disabledWorlds.add(world.getUID());
        }
        return items;
    }

    private void loadItemsFromWorldConfig(@Nonnull String worldName, @Nonnull Config config, @Nonnull Set<String> items) {
        for (SlimefunItem item : Slimefun.getRegistry().getEnabledSlimefunItems()) {
            if (item == null) continue;
            String addon = item.getAddon().getName().toLowerCase(Locale.ROOT);
            config.setDefaultValue(addon + ".enabled", true);
            config.setDefaultValue(addon + "." + item.getId(), true);
            boolean isAddonDisabled = config.getBoolean(addon + ".enabled");
            if (isAddonDisabled) {
                Set blacklist = this.disabledAddons.computeIfAbsent(this.plugin, key -> new HashSet());
                blacklist.add(worldName);
            }
            if (isAddonDisabled && config.getBoolean(addon + "." + item.getId())) continue;
            items.add(item.getId());
        }
    }

    @Nonnull
    private Config getConfig(@Nonnull World world) {
        Validate.notNull(world, "World cannot be null");
        return new Config((Plugin)this.plugin, "world-settings/" + world.getName() + ".yml");
    }
}

