/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

final class ProfiledBlock {
    private final World world;
    private final long position;
    private final SlimefunItem item;

    ProfiledBlock(@Nonnull Location l, @Nonnull SlimefunItem item) {
        this.world = l.getWorld();
        this.position = ProfiledBlock.getLocationAsLong((int)l.getX(), (int)l.getY(), (int)l.getZ());
        this.item = item;
    }

    ProfiledBlock(@Nonnull Block b) {
        this.world = b.getWorld();
        this.position = ProfiledBlock.getLocationAsLong(b.getX(), b.getY(), b.getZ());
        this.item = null;
    }

    private static long getLocationAsLong(int x, int y, int z) {
        return (long)(x & 0x3FFFFFF) << 38 | (long)(z & 0x3FFFFFF) << 12 | (long)(y & 0xFFF);
    }

    @Nonnull
    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return (int)(this.position >> 38);
    }

    public int getY() {
        return (int)(this.position & 0xFFFL);
    }

    public int getZ() {
        return (int)(this.position << 26 >> 38);
    }

    public int getChunkX() {
        return this.getX() >> 4;
    }

    public int getChunkZ() {
        return this.getZ() >> 4;
    }

    @Nonnull
    public String getId() {
        return this.item.getId();
    }

    @Nonnull
    public SlimefunAddon getAddon() {
        return this.item.getAddon();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProfiledBlock) {
            ProfiledBlock block = (ProfiledBlock)obj;
            return this.position == block.position && Objects.equals(this.world, block.world);
        }
        return false;
    }

    public int hashCode() {
        long hilo = this.world.getUID().getMostSignificantBits() ^ this.world.getUID().getLeastSignificantBits();
        return (int)(this.position ^ this.position >> 32 ^ hilo ^ hilo >> 32);
    }
}

