/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSpawnReason;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.networks.NetworkManager;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoNet;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

class CargoNetworkTask
implements Runnable {
    private final NetworkManager manager;
    private final CargoNet network;
    private final Map<Location, Inventory> inventories = new HashMap<Location, Inventory>();
    private final Map<Location, Integer> inputs;
    private final Map<Integer, List<Location>> outputs;

    @ParametersAreNonnullByDefault
    CargoNetworkTask(CargoNet network, Map<Location, Integer> inputs, Map<Integer, List<Location>> outputs) {
        this.network = network;
        this.manager = Slimefun.getNetworkManager();
        this.inputs = inputs;
        this.outputs = outputs;
    }

    @Override
    public void run() {
        long timestamp = System.nanoTime();
        try {
            SlimefunItem inputNode = SlimefunItems.CARGO_INPUT_NODE.getItem();
            for (Map.Entry<Location, Integer> entry : this.inputs.entrySet()) {
                long nodeTimestamp = System.nanoTime();
                Location input = entry.getKey();
                Optional<Block> attachedBlock = this.network.getAttachedBlock(input);
                attachedBlock.ifPresent(block -> this.routeItems(input, (Block)block, (Integer)entry.getValue(), this.outputs));
                timestamp += Slimefun.getProfiler().closeEntry(entry.getKey(), inputNode, nodeTimestamp);
            }
        }
        catch (Exception | LinkageError x) {
            Slimefun.logger().log(Level.SEVERE, x, () -> "An Exception was caught while ticking a Cargo network @ " + new BlockPosition(this.network.getRegulator()));
        }
        Slimefun.getProfiler().closeEntry(this.network.getRegulator(), SlimefunItems.CARGO_MANAGER.getItem(), timestamp);
    }

    @ParametersAreNonnullByDefault
    private void routeItems(Location inputNode, Block inputTarget, int frequency, Map<Integer, List<Location>> outputNodes) {
        ItemStackAndInteger slot = CargoUtils.withdraw(this.network, this.inventories, inputNode.getBlock(), inputTarget);
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.getItem();
        int previousSlot = slot.getInt();
        List<Location> destinations = outputNodes.get(frequency);
        if (destinations != null) {
            stack = this.distributeItem(stack, inputNode, destinations);
        }
        if (stack != null) {
            this.insertItem(inputTarget, previousSlot, stack);
        }
    }

    @ParametersAreNonnullByDefault
    private void insertItem(Block inputTarget, int previousSlot, ItemStack item) {
        Inventory inv = this.inventories.get(inputTarget.getLocation());
        if (inv != null) {
            if (inv.getItem(previousSlot) == null) {
                inv.setItem(previousSlot, item);
            } else {
                ItemStack rest = (ItemStack)inv.addItem(new ItemStack[]{item}).get(0);
                if (rest != null && !this.manager.isItemDeletionEnabled()) {
                    SlimefunUtils.spawnItem(inputTarget.getLocation().add(0.0, 1.0, 0.0), rest, ItemSpawnReason.CARGO_OVERFLOW);
                }
            }
        } else {
            DirtyChestMenu menu = CargoUtils.getChestMenu(inputTarget);
            if (menu != null) {
                if (menu.getItemInSlot(previousSlot) == null) {
                    menu.replaceExistingItem(previousSlot, item);
                } else if (!this.manager.isItemDeletionEnabled()) {
                    SlimefunUtils.spawnItem(inputTarget.getLocation().add(0.0, 1.0, 0.0), item, ItemSpawnReason.CARGO_OVERFLOW);
                }
            }
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private ItemStack distributeItem(ItemStack stack, Location inputNode, List<Location> outputNodes) {
        AbstractCollection destinations;
        ItemStack item = stack;
        Config cfg = BlockStorage.getLocationInfo(inputNode);
        boolean roundrobin = Objects.equals(cfg.getString("round-robin"), "true");
        boolean smartFill = Objects.equals(cfg.getString("smart-fill"), "true");
        if (roundrobin) {
            ArrayDeque<Location> tempDestinations = new ArrayDeque<Location>(outputNodes);
            this.roundRobinSort(inputNode, tempDestinations);
            destinations = tempDestinations;
        } else {
            destinations = new ArrayList<Location>(outputNodes);
        }
        for (Location output : destinations) {
            Optional<Block> target = this.network.getAttachedBlock(output);
            if (!target.isPresent()) continue;
            ItemStackWrapper wrapper = ItemStackWrapper.wrap(item);
            item = CargoUtils.insert(this.network, this.inventories, output.getBlock(), target.get(), smartFill, item, wrapper);
            if (item != null) continue;
            break;
        }
        return item;
    }

    private void roundRobinSort(Location inputNode, Deque<Location> outputNodes) {
        int index = this.network.roundRobin.getOrDefault(inputNode, 0);
        if (index < outputNodes.size()) {
            for (int i = 0; i < index; ++i) {
                Location temp = outputNodes.removeFirst();
                outputNodes.add(temp);
            }
            ++index;
        } else {
            index = 1;
        }
        this.network.roundRobin.put(inputNode, index);
    }
}

