/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.gps;

import io.github.thebusybiscuit.slimefun4.api.events.WaypointCreateEvent;
import io.github.thebusybiscuit.slimefun4.api.geo.ResourceManager;
import io.github.thebusybiscuit.slimefun4.api.gps.TeleportationManager;
import io.github.thebusybiscuit.slimefun4.api.gps.Waypoint;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.gps.GPSTransmitter;
import io.github.thebusybiscuit.slimefun4.libraries.commons.lang.Validate;
import io.github.thebusybiscuit.slimefun4.libraries.dough.chat.ChatInput;
import io.github.thebusybiscuit.slimefun4.libraries.dough.common.ChatColors;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.CustomItemStack;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GPSNetwork {
    private final int[] border = new int[]{0, 1, 3, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};
    private final int[] inventory = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    private final Map<UUID, Set<Location>> transmitters = new HashMap<UUID, Set<Location>>();
    private final TeleportationManager teleportation = new TeleportationManager();
    private final ResourceManager resourceManager;

    public GPSNetwork(@Nonnull Slimefun plugin) {
        this.resourceManager = new ResourceManager(plugin);
    }

    public void updateTransmitter(@Nonnull Location l, @Nonnull UUID uuid, boolean online) {
        Set set = this.transmitters.computeIfAbsent(uuid, id -> new HashSet());
        if (online) {
            set.add(l);
        } else {
            set.remove(l);
        }
    }

    public int getNetworkComplexity(@Nonnull UUID uuid) {
        Set<Location> locations = this.transmitters.get(uuid);
        if (locations == null) {
            return 0;
        }
        int level = 0;
        for (Location l : locations) {
            SlimefunItem item = BlockStorage.check(l);
            if (!(item instanceof GPSTransmitter)) continue;
            level += ((GPSTransmitter)item).getMultiplier(Math.max(l.getBlockY(), 0));
        }
        return level;
    }

    public int countTransmitters(@Nonnull UUID uuid) {
        Set<Location> locations = this.transmitters.get(uuid);
        return locations == null ? 0 : locations.size();
    }

    public void openTransmitterControlPanel(@Nonnull Player p) {
        ChestMenu menu = new ChestMenu(ChatColor.BLUE + Slimefun.getLocalization().getMessage(p, "machines.GPS_CONTROL_PANEL.title"));
        for (int slot2 : this.border) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(2, new CustomItemStack((ItemStack)SlimefunItems.GPS_TRANSMITTER, im -> {
            im.setDisplayName(ChatColor.GRAY + Slimefun.getLocalization().getMessage(p, "machines.GPS_CONTROL_PANEL.transmitters"));
            im.setLore(null);
        }));
        menu.addMenuClickHandler(2, ChestMenuUtils.getEmptyClickHandler());
        int complexity = this.getNetworkComplexity(p.getUniqueId());
        menu.addItem(4, new CustomItemStack((ItemStack)SlimefunItems.GPS_CONTROL_PANEL, "&7Network Info", "", "&8\u21e8 &7Status: " + (complexity > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &f" + complexity));
        menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
        menu.addItem(6, new CustomItemStack(HeadTexture.GLOBE_OVERWORLD.getAsItemStack(), "&7" + Slimefun.getLocalization().getMessage(p, "machines.GPS_CONTROL_PANEL.waypoints"), "", ChatColor.GRAY + "\u21e8 " + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup")));
        menu.addMenuClickHandler(6, (pl, slot, item, action) -> {
            this.openWaypointControlPanel(pl);
            return false;
        });
        int index = 0;
        for (Location l : this.getTransmitters(p.getUniqueId())) {
            if (index >= this.inventory.length) break;
            SlimefunItem sfi = BlockStorage.check(l);
            if (!(sfi instanceof GPSTransmitter)) continue;
            int slot3 = this.inventory[index];
            menu.addItem(slot3, new CustomItemStack((ItemStack)SlimefunItems.GPS_TRANSMITTER, "&bGPS Transmitter", "&8\u21e8 &7World: &f" + l.getWorld().getName(), "&8\u21e8 &7X: &f" + l.getX(), "&8\u21e8 &7Y: &f" + l.getY(), "&8\u21e8 &7Z: &f" + l.getZ(), "", "&8\u21e8 &7Signal Strength: &f" + ((GPSTransmitter)sfi).getMultiplier(l.getBlockY()), "&8\u21e8 &7Ping: &f" + NumberUtils.roundDecimalNumber(1000.0 / l.getY()) + "ms"));
            menu.addMenuClickHandler(slot3, ChestMenuUtils.getEmptyClickHandler());
            ++index;
        }
        menu.open(p);
    }

    @Nonnull
    public ItemStack getIcon(@Nonnull String name, @Nonnull World.Environment environment) {
        if (name.startsWith("player:death ")) {
            return HeadTexture.DEATHPOINT.getAsItemStack();
        }
        if (environment == World.Environment.NETHER) {
            return HeadTexture.GLOBE_NETHER.getAsItemStack();
        }
        if (environment == World.Environment.THE_END) {
            return HeadTexture.GLOBE_THE_END.getAsItemStack();
        }
        return HeadTexture.GLOBE_OVERWORLD.getAsItemStack();
    }

    public void openWaypointControlPanel(@Nonnull Player p) {
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            ChestMenu menu = new ChestMenu(ChatColor.BLUE + Slimefun.getLocalization().getMessage(p, "machines.GPS_CONTROL_PANEL.title"));
            for (int slot2 : this.border) {
                menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
            }
            menu.addItem(2, new CustomItemStack((ItemStack)SlimefunItems.GPS_TRANSMITTER, "&7" + Slimefun.getLocalization().getMessage(p, "machines.GPS_CONTROL_PANEL.transmitters"), "", ChatColor.GRAY + "\u21e8 " + Slimefun.getLocalization().getMessage(p, "guide.tooltips.open-itemgroup")));
            menu.addMenuClickHandler(2, (pl, slot, item, action) -> {
                this.openTransmitterControlPanel(pl);
                return false;
            });
            int complexity = this.getNetworkComplexity(p.getUniqueId());
            menu.addItem(4, new CustomItemStack((ItemStack)SlimefunItems.GPS_CONTROL_PANEL, "&7Network Info", "", "&8\u21e8 &7Status: " + (complexity > 0 ? "&2&lONLINE" : "&4&lOFFLINE"), "&8\u21e8 &7Complexity: &f" + complexity));
            menu.addMenuClickHandler(4, ChestMenuUtils.getEmptyClickHandler());
            menu.addItem(6, new CustomItemStack(HeadTexture.GLOBE_OVERWORLD.getAsItemStack(), "&7" + Slimefun.getLocalization().getMessage(p, "machines.GPS_CONTROL_PANEL.waypoints"), new String[0]));
            menu.addMenuClickHandler(6, ChestMenuUtils.getEmptyClickHandler());
            int index = 0;
            for (Waypoint waypoint : profile.getWaypoints()) {
                if (index >= this.inventory.length) break;
                int slot3 = this.inventory[index];
                Location l = waypoint.getLocation();
                menu.addItem(slot3, new CustomItemStack(waypoint.getIcon(), waypoint.getName().replace("player:death ", ""), "&8\u21e8 &7World: &f" + l.getWorld().getName(), "&8\u21e8 &7X: &f" + l.getX(), "&8\u21e8 &7Y: &f" + l.getY(), "&8\u21e8 &7Z: &f" + l.getZ(), "", "&8\u21e8 &cClick to delete"));
                menu.addMenuClickHandler(slot3, (pl, s, item, action) -> {
                    profile.removeWaypoint(waypoint);
                    pl.playSound(pl.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    this.openWaypointControlPanel(pl);
                    return false;
                });
                ++index;
            }
            menu.open(p);
        });
    }

    public void createWaypoint(@Nonnull Player p, @Nonnull Location l) {
        Validate.notNull(p, "Player cannot be null!");
        Validate.notNull(l, "Waypoint Location cannot be null!");
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            if (profile.getWaypoints().size() + 2 > this.inventory.length) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "gps.waypoint.max", true);
                return;
            }
            Slimefun.getLocalization().sendMessage((CommandSender)p, "gps.waypoint.new", true);
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.0f);
            ChatInput.waitForPlayer((Plugin)Slimefun.instance(), p, message -> this.addWaypoint(p, (String)message, l));
        });
    }

    public void addWaypoint(@Nonnull Player p, @Nonnull String name, @Nonnull Location l) {
        Validate.notNull(p, "Player cannot be null!");
        Validate.notNull(name, "Waypoint name cannot be null!");
        Validate.notNull(l, "Waypoint Location cannot be null!");
        PlayerProfile.get((OfflinePlayer)p, profile -> {
            if (profile.getWaypoints().size() + 2 > this.inventory.length) {
                Slimefun.getLocalization().sendMessage((CommandSender)p, "gps.waypoint.max", true);
                return;
            }
            Slimefun.runSync(() -> {
                WaypointCreateEvent event = new WaypointCreateEvent(p, name, l);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    String id = ChatColor.stripColor((String)ChatColors.color(event.getName())).toUpperCase(Locale.ROOT).replace(' ', '_');
                    for (Waypoint wp : profile.getWaypoints()) {
                        if (!wp.getId().equals(id)) continue;
                        Slimefun.getLocalization().sendMessage((CommandSender)p, "gps.waypoint.duplicate", true, msg -> msg.replace("%waypoint%", event.getName()));
                        return;
                    }
                    profile.addWaypoint(new Waypoint((PlayerProfile)profile, id, event.getLocation(), event.getName()));
                    p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                    Slimefun.getLocalization().sendMessage((CommandSender)p, "gps.waypoint.added", true);
                }
            });
        });
    }

    @Nonnull
    public Set<Location> getTransmitters(@Nonnull UUID uuid) {
        return this.transmitters.getOrDefault(uuid, new HashSet());
    }

    @Nonnull
    public TeleportationManager getTeleportationManager() {
        return this.teleportation;
    }

    @Nonnull
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }
}

