/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.AdvancedIndustrialMiner;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.IndustrialMiner;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.MinerStoppingReason;
import io.github.thebusybiscuit.slimefun4.libraries.dough.blocks.BlockPosition;
import io.github.thebusybiscuit.slimefun4.libraries.dough.inventory.InvUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.items.ItemUtils;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.scheduling.TaskQueue;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.WorldUtils;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.data.type.PistonHead;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class MiningTask
implements Runnable {
    private final IndustrialMiner miner;
    private final UUID owner;
    private final Block chest;
    private final Block[] pistons;
    private final BlockPosition start;
    private final BlockPosition end;
    private final int height;
    private boolean running = false;
    private int fuelLevel = 0;
    private int ores = 0;
    private int x;
    private int z;

    @ParametersAreNonnullByDefault
    MiningTask(IndustrialMiner miner, UUID owner, Block chest, Block[] pistons, Block start, Block end) {
        this.miner = miner;
        this.owner = owner;
        this.chest = chest;
        this.pistons = pistons;
        this.start = new BlockPosition(start);
        this.end = new BlockPosition(end);
        this.height = start.getY();
        this.x = start.getX();
        this.z = start.getZ();
    }

    void start(@Nonnull Block b) {
        this.miner.activeMiners.put(b.getLocation(), this);
        this.running = true;
        this.warmUp();
    }

    void stop() {
        this.running = false;
        this.miner.activeMiners.remove(this.chest.getRelative(BlockFace.DOWN).getLocation());
    }

    void stop(@Nonnull MinerStoppingReason reason) {
        Player p = Bukkit.getPlayer((UUID)this.owner);
        if (p != null) {
            Slimefun.getLocalization().sendMessage((CommandSender)p, reason.getErrorMessage());
        }
        this.stop();
    }

    private void warmUp() {
        TaskQueue queue = new TaskQueue();
        queue.thenRun(4, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(10, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(8, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(10, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(() -> {
            this.consumeFuel();
            if (this.fuelLevel <= 0) {
                this.stop(MinerStoppingReason.NO_FUEL);
                return;
            }
        });
        queue.thenRun(6, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(9, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(4, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(7, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(5, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(2, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(4, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(1, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(1, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(2, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(1, this);
        queue.execute((Plugin)Slimefun.instance());
    }

    @Override
    public void run() {
        if (!this.running) {
            return;
        }
        TaskQueue queue = new TaskQueue();
        queue.thenRun(1, () -> this.setPistonState(this.pistons[0], true));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[0], false));
        queue.thenRun(1, () -> this.setPistonState(this.pistons[1], true));
        queue.thenRun(3, () -> this.setPistonState(this.pistons[1], false));
        queue.thenRun(() -> {
            try {
                Block furnace = this.chest.getRelative(BlockFace.DOWN);
                furnace.getWorld().playEffect(furnace.getLocation(), Effect.STEP_SOUND, (Object)Material.STONE);
                World world = this.start.getWorld();
                for (int y = this.height; y > WorldUtils.getMinHeight(world); --y) {
                    Block b = world.getBlockAt(this.x, y, this.z);
                    if (!Slimefun.getProtectionManager().hasPermission(Bukkit.getOfflinePlayer((UUID)this.owner), b, Interaction.BREAK_BLOCK)) {
                        this.stop(MinerStoppingReason.NO_PERMISSION);
                        return;
                    }
                    if (!this.miner.canMine(b.getType()) || !this.push(this.miner.getOutcome(b.getType()))) continue;
                    furnace.getWorld().playEffect(furnace.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                    furnace.getWorld().playSound(furnace.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 0.2f, 1.0f);
                    b.setType(Material.AIR);
                    --this.fuelLevel;
                    ++this.ores;
                    Slimefun.runSync(this, 4L);
                    return;
                }
                this.nextColumn();
            }
            catch (Exception e) {
                Slimefun.logger().log(Level.SEVERE, e, () -> "An Error occurred while running an Industrial Miner at " + new BlockPosition(this.chest));
                this.stop();
            }
        });
        queue.execute((Plugin)Slimefun.instance());
    }

    private void nextColumn() {
        if (this.x < this.end.getX()) {
            ++this.x;
        } else if (this.z < this.end.getZ()) {
            this.x = this.start.getX();
            ++this.z;
        } else {
            this.stop();
            Player p = Bukkit.getPlayer((UUID)this.owner);
            if (p != null) {
                p.playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 0.4f, 1.0f);
                Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.INDUSTRIAL_MINER.finished", msg -> msg.replace("%ores%", String.valueOf(this.ores)));
            }
            return;
        }
        Slimefun.runSync(this, 5L);
    }

    private boolean push(@Nonnull ItemStack item) {
        if (this.fuelLevel < 1) {
            this.consumeFuel();
        }
        if (this.fuelLevel > 0) {
            if (this.chest.getType() == Material.CHEST) {
                BlockState state = PaperLib.getBlockState(this.chest, false).getState();
                if (state instanceof Chest) {
                    Inventory inv = ((Chest)state).getBlockInventory();
                    if (InvUtils.fits(inv, item, new int[0])) {
                        inv.addItem(new ItemStack[]{item});
                        return true;
                    }
                    this.stop(MinerStoppingReason.CHEST_FULL);
                } else {
                    this.stop(MinerStoppingReason.STRUCTURE_DESTROYED);
                }
            } else {
                this.stop(MinerStoppingReason.STRUCTURE_DESTROYED);
            }
        } else {
            this.stop(MinerStoppingReason.NO_FUEL);
        }
        return false;
    }

    private void consumeFuel() {
        BlockState state;
        if (this.chest.getType() == Material.CHEST && (state = PaperLib.getBlockState(this.chest, false).getState()) instanceof Chest) {
            Inventory inv = ((Chest)state).getBlockInventory();
            this.fuelLevel = this.grabFuelFrom(inv);
        }
    }

    private int grabFuelFrom(@Nonnull Inventory inv) {
        for (int i = 0; i < inv.getSize(); ++i) {
            for (MachineFuel fuelType : this.miner.fuelTypes) {
                ItemStack item;
                if (!fuelType.test(item = inv.getContents()[i]) || !this.running) continue;
                ItemUtils.consumeItem(item, false);
                if (this.miner instanceof AdvancedIndustrialMiner) {
                    inv.addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                }
                return fuelType.getTicks();
            }
        }
        return 0;
    }

    private void setPistonState(@Nonnull Block block, boolean extended) {
        if (!this.running) {
            return;
        }
        try {
            Location particleLoc = this.chest.getLocation().clone().add(0.0, -1.0, 0.0);
            block.getWorld().spawnParticle(Particle.SMOKE_NORMAL, particleLoc, 20, 0.7, 0.7, 0.7, 0.0);
            if (block.getType() == Material.MOVING_PISTON) {
                block.getRelative(BlockFace.UP).setType(Material.AIR);
            } else if (block.getType() == Material.PISTON) {
                Block above = block.getRelative(BlockFace.UP);
                if (above.isEmpty() || above.getType() == Material.PISTON_HEAD) {
                    Piston piston = (Piston)block.getBlockData();
                    if (piston.getFacing() == BlockFace.UP) {
                        this.setExtended(block, piston, extended);
                    } else {
                        this.stop(MinerStoppingReason.PISTON_WRONG_DIRECTION);
                    }
                } else {
                    this.stop(MinerStoppingReason.PISTON_NO_SPACE);
                }
            } else {
                this.stop(MinerStoppingReason.STRUCTURE_DESTROYED);
            }
        }
        catch (Exception e) {
            Slimefun.logger().log(Level.SEVERE, e, () -> "An Error occurred while moving a Piston for an Industrial Miner at " + new BlockPosition(block));
            this.stop();
        }
    }

    private void setExtended(@Nonnull Block block, @Nonnull Piston piston, boolean extended) {
        piston.setExtended(extended);
        block.setBlockData((BlockData)piston, false);
        if (extended) {
            PistonHead head = (PistonHead)Material.PISTON_HEAD.createBlockData();
            head.setFacing(BlockFace.UP);
            block.getRelative(BlockFace.UP).setBlockData((BlockData)head, false);
        } else {
            block.getRelative(BlockFace.UP).setType(Material.AIR);
        }
        block.getWorld().playSound(block.getLocation(), extended ? Sound.BLOCK_PISTON_EXTEND : Sound.BLOCK_PISTON_CONTRACT, 0.1f, 1.0f);
    }
}

