/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.inventory.ItemStack;

public class BlockPlacerPlaceEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Block blockPlacer;
    private ItemStack placedItem;
    private boolean cancelled = false;
    private boolean locked = false;

    @ParametersAreNonnullByDefault
    public BlockPlacerPlaceEvent(Block blockPlacer, ItemStack placedItem, Block block) {
        super(block);
        this.placedItem = placedItem;
        this.blockPlacer = blockPlacer;
    }

    @Nonnull
    public Block getBlockPlacer() {
        return this.blockPlacer;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.placedItem;
    }

    public void setItemStack(@Nonnull ItemStack item) {
        Validate.notNull((Object)item, (String)"The ItemStack must not be null!");
        if (!this.locked) {
            this.placedItem = item;
        } else {
            SlimefunItem.getByItem(this.placedItem).warn("A BlockPlacerPlaceEvent cannot be modified from within a BlockPlaceHandler!");
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        if (!this.locked) {
            this.cancelled = cancel;
        } else {
            SlimefunItem.getByItem(this.placedItem).warn("A BlockPlacerPlaceEvent cannot be modified from within a BlockPlaceHandler!");
        }
    }

    public void setImmutable() {
        this.locked = true;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return BlockPlacerPlaceEvent.getHandlerList();
    }
}

