/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerHead;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class CapacitorTextureUpdateTask
implements Runnable {
    private final Location l;
    private final double filledPercentage;

    public CapacitorTextureUpdateTask(@Nonnull Location l, double charge, double capacity) {
        Validate.notNull((Object)l, (String)"The Location cannot be null");
        this.l = l;
        this.filledPercentage = charge / capacity;
    }

    @Override
    public void run() {
        Block b = this.l.getBlock();
        Material type = b.getType();
        if (type == Material.PLAYER_HEAD || type == Material.PLAYER_WALL_HEAD) {
            if (this.filledPercentage <= 0.25) {
                this.setTexture(b, HeadTexture.CAPACITOR_25);
            } else if (this.filledPercentage <= 0.5) {
                this.setTexture(b, HeadTexture.CAPACITOR_50);
            } else if (this.filledPercentage <= 0.75) {
                this.setTexture(b, HeadTexture.CAPACITOR_75);
            } else {
                this.setTexture(b, HeadTexture.CAPACITOR_100);
            }
        }
    }

    private void setTexture(@Nonnull Block b, @Nonnull HeadTexture texture) {
        PlayerSkin skin = PlayerSkin.fromHashCode(texture.getUniqueId(), texture.getTexture());
        PlayerHead.setSkin(b, skin, false);
        PaperLib.getBlockState(b, false).getState().update(true, false);
    }
}

