/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines.electric;

import java.util.ArrayList;
import java.util.List;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Lists.SlimefunItems;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.RecipeDisplayItem;
import me.mrCookieSlime.Slimefun.Setup.SlimefunManager;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.utils.MachineHelper;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class AutoDrier
extends AContainer
implements RecipeDisplayItem {
    private final List<ItemStack> recipeList = new ArrayList<ItemStack>();

    public AutoDrier(Category category, ItemStack item, String id, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, id, recipeType, recipe);
        this.recipeList.add(new ItemStack(Material.ROTTEN_FLESH));
        this.recipeList.add(new ItemStack(Material.LEATHER));
        this.recipeList.add(new ItemStack(Material.WET_SPONGE));
        this.recipeList.add(new ItemStack(Material.SPONGE));
        this.recipeList.add(new ItemStack(Material.KELP));
        this.recipeList.add(new ItemStack(Material.DRIED_KELP));
        this.recipeList.add(new ItemStack(Material.COOKED_BEEF));
        this.recipeList.add(SlimefunItems.BEEF_JERKY);
        this.recipeList.add(new ItemStack(Material.POTION));
        this.recipeList.add(new ItemStack(Material.GLASS_BOTTLE));
        this.recipeList.add(new ItemStack(Material.OAK_SAPLING));
        this.recipeList.add(new ItemStack(Material.STICK, 2));
        this.recipeList.add(new ItemStack(Material.OAK_LEAVES));
        this.recipeList.add(new ItemStack(Material.STICK));
        this.recipeList.add(new ItemStack(Material.WATER_BUCKET));
        this.recipeList.add(new ItemStack(Material.BUCKET));
    }

    @Override
    public String getInventoryTitle() {
        return "&eAuto Drier";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.FLINT_AND_STEEL);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipeList;
    }

    @Override
    protected void tick(Block b) {
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                MachineHelper.updateProgressbar(BlockStorage.getInventory(b), 22, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (ChargableBlock.isChargable(b)) {
                    if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
                        return;
                    }
                    ChargableBlock.addCharge(b, -this.getEnergyConsumption());
                    progress.put(b, timeleft - 1);
                } else {
                    progress.put(b, timeleft - 1);
                }
            } else {
                BlockStorage.getInventory(b).replaceExistingItem(22, (ItemStack)new CustomItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " "));
                this.pushItems(b, ((MachineRecipe)processing.get(b)).getOutput());
                progress.remove(b);
                processing.remove(b);
            }
        } else {
            MachineRecipe r = null;
            int inputSlot = -1;
            for (int slot : this.getInputSlots()) {
                ItemStack item = BlockStorage.getInventory(b).getItemInSlot(slot);
                if (item == null) continue;
                Material mat = item.getType();
                ItemStack output = null;
                for (int i = 0; i < this.recipeList.size(); i += 2) {
                    if (!SlimefunManager.isItemSimiliar(item, this.recipeList.get(i), true)) continue;
                    output = this.recipeList.get(i + 1);
                }
                if (Tag.SAPLINGS.isTagged((Keyed)mat)) {
                    output = new ItemStack(Material.STICK, 2);
                } else if (Tag.LEAVES.isTagged((Keyed)mat)) {
                    output = new ItemStack(Material.STICK, 1);
                } else if (mat == Material.SPLASH_POTION || mat == Material.LINGERING_POTION) {
                    output = new ItemStack(Material.GLASS_BOTTLE);
                }
                if (output == null) continue;
                r = new MachineRecipe(6, new ItemStack[]{item}, new ItemStack[]{output.clone()});
                inputSlot = slot;
                break;
            }
            if (r != null) {
                if (inputSlot == -1) {
                    return;
                }
                if (!this.fits(b, r.getOutput())) {
                    return;
                }
                BlockStorage.getInventory(b).replaceExistingItem(inputSlot, InvUtils.decreaseItem((ItemStack)BlockStorage.getInventory(b).getItemInSlot(inputSlot), (int)1));
                processing.put(b, r);
                progress.put(b, r.getTicks());
            }
        }
    }

    @Override
    public int getEnergyConsumption() {
        return 5;
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_DRIER";
    }
}

