/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.api.inventory;

import java.io.File;
import java.util.ArrayList;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.ItemManipulationEvent;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UniversalBlockMenu
extends DirtyChestMenu {
    private BlockMenuPreset preset;
    private ItemManipulationEvent event;

    public UniversalBlockMenu(BlockMenuPreset preset) {
        super(preset.getTitle());
        this.preset = preset;
        this.changes = 1;
        preset.clone(this);
        this.save();
    }

    public UniversalBlockMenu(BlockMenuPreset preset, Config cfg) {
        super(preset.getTitle());
        this.preset = preset;
        for (int i = 0; i < 54; ++i) {
            if (!cfg.contains(String.valueOf(i))) continue;
            this.addItem(i, cfg.getItem(String.valueOf(i)));
        }
        preset.clone(this);
        if (preset.getSize() > -1 && !preset.getPresetSlots().contains(preset.getSize() - 1) && cfg.contains(String.valueOf(preset.getSize() - 1))) {
            this.addItem(preset.getSize() - 1, cfg.getItem(String.valueOf(preset.getSize() - 1)));
        }
        this.getContents();
    }

    public void registerEvent(ItemManipulationEvent event) {
        this.event = event;
    }

    public void save() {
        if (!this.isDirty()) {
            return;
        }
        this.getContents();
        File file = new File("data-storage/Slimefun/universal-inventories/" + this.preset.getID() + ".sfi");
        Config cfg = new Config(file);
        cfg.setValue("preset", (Object)this.preset.getID());
        for (int slot : this.preset.getInventorySlots()) {
            cfg.setValue(String.valueOf(slot), (Object)this.getItemInSlot(slot));
        }
        cfg.save();
        this.changes = 0;
    }

    public BlockMenuPreset getPreset() {
        return this.preset;
    }

    public boolean canOpen(Block b, Player p) {
        return this.preset.canOpen(b, p);
    }

    public void replaceExistingItem(int slot, ItemStack item) {
        this.replaceExistingItem(slot, item, true);
    }

    public void replaceExistingItem(int slot, ItemStack item, boolean event) {
        ItemStack previous = this.getItemInSlot(slot);
        if (event && this.event != null) {
            item = this.event.onEvent(slot, previous, item);
        }
        super.replaceExistingItem(slot, item);
        this.markDirty();
    }

    public void close() {
        for (HumanEntity human : new ArrayList(this.toInventory().getViewers())) {
            human.closeInventory();
        }
    }
}

