/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.dough.skins;

import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.CustomGameProfile;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.PlayerSkin;
import io.github.thebusybiscuit.slimefun4.libraries.dough.skins.nms.PlayerHeadAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class PlayerHead {
    private static final PlayerHeadAdapter adapter = PlayerHeadAdapter.get();

    private PlayerHead() {
    }

    @Nonnull
    public static ItemStack getItemStack(@Nonnull OfflinePlayer player) {
        Validate.notNull((Object)player, (String)"The player can not be null!");
        return PlayerHead.getItemStack((SkullMeta meta) -> meta.setOwningPlayer(player));
    }

    @Nonnull
    public static ItemStack getItemStack(@Nonnull PlayerSkin skin) {
        Validate.notNull((Object)skin, (String)"The skin can not be null!");
        return PlayerHead.getItemStack((SkullMeta meta) -> {
            try {
                skin.getProfile().apply((SkullMeta)meta);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        });
    }

    @Nonnull
    private static ItemStack getItemStack(@Nonnull Consumer<SkullMeta> consumer) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        consumer.accept(meta);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @ParametersAreNonnullByDefault
    public static void setSkin(Block block, PlayerSkin skin, boolean sendBlockUpdate) {
        if (adapter == null) {
            throw new UnsupportedOperationException("Cannot update skin texture, no adapter found");
        }
        Material material = block.getType();
        if (material != Material.PLAYER_HEAD && material != Material.PLAYER_WALL_HEAD) {
            throw new IllegalArgumentException("Cannot update a head texture. Expected a Player Head, received: " + material);
        }
        try {
            CustomGameProfile profile = skin.getProfile();
            Object tileEntity = adapter.getTileEntity(block);
            if (tileEntity != null) {
                adapter.setGameProfile(tileEntity, profile);
                if (sendBlockUpdate) {
                    block.getState().update(true, false);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

