/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.ProtectionType;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.items.armor.SlimefunArmorPiece;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class ElytraImpactListener
implements Listener {
    public ElytraImpactListener(@Nonnull Slimefun plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerCrash(EntityDamageEvent e) {
        Player p;
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        if ((e.getCause() == EntityDamageEvent.DamageCause.FALL || e.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) && (p = (Player)e.getEntity()).isGliding()) {
            SlimefunItem item;
            Optional<PlayerProfile> optional = PlayerProfile.find((OfflinePlayer)p);
            if (!optional.isPresent()) {
                PlayerProfile.request((OfflinePlayer)p);
                return;
            }
            PlayerProfile profile = optional.get();
            Optional<SlimefunArmorPiece> helmet = profile.getArmor()[0].getItem();
            if (helmet.isPresent() && (item = (SlimefunItem)helmet.get()).canUse(p, true) && profile.hasFullProtectionAgainst(ProtectionType.FLYING_INTO_WALL)) {
                e.setDamage(0.0);
                p.playSound(p.getLocation(), Sound.BLOCK_STONE_HIT, 20.0f, 1.0f);
                if (item instanceof DamageableItem) {
                    ((DamageableItem)((Object)item)).damageItem(p, p.getInventory().getHelmet());
                }
            }
        }
    }
}

