/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class ErrorReport<T extends Throwable> {
    private static final DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm", Locale.ROOT);
    private static final AtomicInteger count = new AtomicInteger(0);
    private final SlimefunAddon addon;
    private final T throwable;
    private File file;

    @ParametersAreNonnullByDefault
    public ErrorReport(T throwable, SlimefunAddon addon, Consumer<PrintStream> printer) {
        this.throwable = throwable;
        this.addon = addon;
        Slimefun.runSync(() -> this.print(printer));
    }

    @ParametersAreNonnullByDefault
    public ErrorReport(T throwable, Location l, SlimefunItem item) {
        this(throwable, item.getAddon(), (PrintStream stream) -> {
            stream.println("Block Info:");
            stream.println("  World: " + l.getWorld().getName());
            stream.println("  X: " + l.getBlockX());
            stream.println("  Y: " + l.getBlockY());
            stream.println("  Z: " + l.getBlockZ());
            stream.println("  Material: " + l.getBlock().getType());
            stream.println("  Block Data: " + l.getBlock().getBlockData().getClass().getName());
            stream.println("  State: " + l.getBlock().getState().getClass().getName());
            stream.println();
            if (item.getBlockTicker() != null) {
                stream.println("Ticker-Info:");
                stream.println("  Type: " + (item.getBlockTicker().isSynchronized() ? "Synchronized" : "Asynchronous"));
                stream.println();
            }
            if (item instanceof EnergyNetProvider) {
                stream.println("Ticker-Info:");
                stream.println("  Type: Indirect (Energy Network)");
                stream.println();
            }
            stream.println("Slimefun Data:");
            stream.println("  ID: " + item.getId());
            stream.println("  Inventory: " + BlockStorage.getStorage(l.getWorld()).hasInventory(l));
            stream.println("  Data: " + BlockStorage.getBlockInfoAsJson(l));
            stream.println();
        });
    }

    @ParametersAreNonnullByDefault
    public ErrorReport(T throwable, SlimefunItem item) {
        this(throwable, item.getAddon(), (PrintStream stream) -> {
            stream.println("SlimefunItem:");
            stream.println("  ID: " + item.getId());
            stream.println("  Plugin: " + (item.getAddon() == null ? "Unknown" : item.getAddon().getName()));
            stream.println();
        });
    }

    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Nonnull
    public T getThrown() {
        return this.throwable;
    }

    public static int count() {
        return count.get();
    }

    private void print(@Nonnull Consumer<PrintStream> printer) {
        this.file = ErrorReport.getNewFile();
        count.incrementAndGet();
        try (PrintStream stream = new PrintStream(this.file, StandardCharsets.UTF_8.name());){
            stream.println();
            stream.println("Error Generated: " + dateFormat.format(LocalDateTime.now()));
            stream.println();
            stream.println("Java Environment:");
            stream.println("  Operating System: " + System.getProperty("os.name"));
            stream.println("  Java Version: " + System.getProperty("java.version"));
            stream.println();
            String serverSoftware = PaperLib.isSpigot() && !PaperLib.isPaper() ? "Spigot" : Bukkit.getName();
            stream.println("Server Software: " + serverSoftware);
            stream.println("  Build: " + Bukkit.getVersion());
            stream.println("  Minecraft v" + Bukkit.getBukkitVersion());
            stream.println();
            stream.println("Slimefun Environment:");
            stream.println("  Slimefun v" + Slimefun.getVersion());
            stream.println("  Caused by: " + this.addon.getName() + " v" + this.addon.getPluginVersion());
            stream.println();
            ArrayList<String> plugins = new ArrayList<String>();
            ArrayList<String> addons = new ArrayList<String>();
            ErrorReport.scanPlugins(plugins, addons);
            stream.println("Installed Addons (" + addons.size() + ")");
            addons.forEach(stream::println);
            stream.println();
            stream.println("Installed Plugins (" + plugins.size() + "):");
            plugins.forEach(stream::println);
            stream.println();
            printer.accept(stream);
            stream.println("Stacktrace:");
            stream.println();
            ((Throwable)this.throwable).printStackTrace(stream);
            this.addon.getLogger().log(Level.WARNING, "");
            this.addon.getLogger().log(Level.WARNING, "An Error occurred! It has been saved as: ");
            this.addon.getLogger().log(Level.WARNING, "/plugins/Slimefun/error-reports/{0}", this.file.getName());
            this.addon.getLogger().log(Level.WARNING, "Please put this file on https://pastebin.com/ and report this to the developer(s).");
            if (this.addon.getBugTrackerURL() != null) {
                this.addon.getLogger().log(Level.WARNING, "Bug Tracker: {0}", this.addon.getBugTrackerURL());
            }
            this.addon.getLogger().log(Level.WARNING, "");
        }
        catch (Exception x) {
            this.addon.getLogger().log(Level.SEVERE, x, () -> "An Error occurred while saving an Error-Report for Slimefun " + Slimefun.getVersion());
        }
    }

    private static void scanPlugins(@Nonnull List<String> plugins, @Nonnull List<String> addons) {
        String dependency = "Slimefun";
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (Bukkit.getPluginManager().isPluginEnabled(plugin)) {
                plugins.add("  + " + plugin.getName() + ' ' + plugin.getDescription().getVersion());
                if (!plugin.getDescription().getDepend().contains(dependency) && !plugin.getDescription().getSoftDepend().contains(dependency)) continue;
                addons.add("  + " + plugin.getName() + ' ' + plugin.getDescription().getVersion());
                continue;
            }
            plugins.add("  - " + plugin.getName() + ' ' + plugin.getDescription().getVersion());
            if (!plugin.getDescription().getDepend().contains(dependency) && !plugin.getDescription().getSoftDepend().contains(dependency)) continue;
            addons.add("  - " + plugin.getName() + ' ' + plugin.getDescription().getVersion());
        }
    }

    @Nonnull
    private static File getNewFile() {
        String path = "plugins/Slimefun/error-reports/" + dateFormat.format(LocalDateTime.now());
        File newFile = new File(path + ".err");
        if (newFile.exists()) {
            IntStream stream = IntStream.iterate(1, i -> i + 1).filter(i -> !new File(path + " (" + i + ").err").exists());
            int id = stream.findFirst().getAsInt();
            newFile = new File(path + " (" + id + ").err");
        }
        return newFile;
    }

    public static void tryCatch(@Nonnull Function<Exception, ErrorReport<Exception>> function, @Nonnull Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception x) {
            function.apply(x);
        }
    }
}

