/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OreWasher
extends MultiBlockMachine {
    private final ItemStack[] dusts = new ItemStack[]{SlimefunItems.IRON_DUST, SlimefunItems.GOLD_DUST, SlimefunItems.COPPER_DUST, SlimefunItems.TIN_DUST, SlimefunItems.ZINC_DUST, SlimefunItems.ALUMINUM_DUST, SlimefunItems.MAGNESIUM_DUST, SlimefunItems.LEAD_DUST, SlimefunItems.SILVER_DUST};
    private final boolean legacyMode = Slimefun.getCfg().getBoolean("options.legacy-ore-washer");

    @ParametersAreNonnullByDefault
    public OreWasher(ItemGroup itemGroup, SlimefunItemStack item) {
        super(itemGroup, item, new ItemStack[]{null, new ItemStack(Material.DISPENSER), null, null, new ItemStack(Material.OAK_FENCE), null, null, new ItemStack(Material.CAULDRON), null}, BlockFace.SELF);
    }

    @Override
    protected void registerDefaultRecipes(List<ItemStack> recipes) {
        recipes.add(SlimefunItems.SIFTED_ORE);
        recipes.add(SlimefunItems.IRON_DUST);
        recipes.add(SlimefunItems.SIFTED_ORE);
        recipes.add(SlimefunItems.GOLD_DUST);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        return this.recipes.stream().map(items -> items[0]).collect(Collectors.toList());
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block dispBlock = b.getRelative(BlockFace.UP);
        BlockState state = PaperLib.getBlockState(dispBlock, false).getState();
        if (state instanceof Dispenser) {
            Dispenser disp = (Dispenser)state;
            Inventory inv = disp.getInventory();
            for (ItemStack input : inv.getContents()) {
                if (input == null) continue;
                if (SlimefunUtils.isItemSimilar(input, SlimefunItems.SIFTED_ORE, true)) {
                    ItemStack output = this.getRandomDust();
                    Inventory outputInv = null;
                    if (!this.legacyMode) {
                        SlimefunItemStack dummyAdding = SlimefunItems.DEBUG_FISH;
                        outputInv = this.findOutputInventory(dummyAdding, dispBlock, inv);
                    } else {
                        outputInv = this.findOutputInventory(output, dispBlock, inv);
                    }
                    this.removeItem(p, b, inv, outputInv, input, output, 1);
                    if (outputInv != null) {
                        outputInv.addItem(new ItemStack[]{SlimefunItems.STONE_CHUNK});
                    }
                    return;
                }
                if (SlimefunUtils.isItemSimilar(input, new ItemStack(Material.SAND, 2), false)) {
                    SlimefunItemStack output = SlimefunItems.SALT;
                    Inventory outputInv = this.findOutputInventory(output, dispBlock, inv);
                    this.removeItem(p, b, inv, outputInv, input, output, 2);
                    return;
                }
                if (!SlimefunUtils.isItemSimilar(input, SlimefunItems.PULVERIZED_ORE, true)) continue;
                SlimefunItemStack output = SlimefunItems.PURE_ORE_CLUSTER;
                Inventory outputInv = this.findOutputInventory(output, dispBlock, inv);
                this.removeItem(p, b, inv, outputInv, input, output, 1);
                return;
            }
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.unknown-material", true);
        }
    }

    @ParametersAreNonnullByDefault
    private void removeItem(Player p, Block b, Inventory inputInv, @Nullable Inventory outputInv, ItemStack input, ItemStack output, int amount) {
        if (outputInv != null) {
            ItemStack removing = input.clone();
            removing.setAmount(amount);
            inputInv.removeItem(new ItemStack[]{removing});
            outputInv.addItem(new ItemStack[]{output.clone()});
            b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)Material.WATER);
            b.getWorld().playSound(b.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.0f);
        } else {
            Slimefun.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }

    @Nonnull
    public ItemStack getRandomDust() {
        int index = ThreadLocalRandom.current().nextInt(this.dusts.length);
        return this.dusts[index].clone();
    }
}

