/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

abstract class AbstractPlayerTask
implements Runnable {
    protected final Player p;
    private int id;

    AbstractPlayerTask(@Nonnull Player p) {
        this.p = p;
    }

    private void setID(int id) {
        this.id = id;
    }

    public void schedule(long delay) {
        this.setID(Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SlimefunPlugin.instance(), (Runnable)this, delay));
    }

    public void scheduleRepeating(long delay, long interval) {
        this.setID(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)SlimefunPlugin.instance(), (Runnable)this, delay, interval));
    }

    @Override
    public final void run() {
        if (this.isValid()) {
            this.executeTask();
        }
    }

    public final void cancel() {
        Bukkit.getScheduler().cancelTask(this.id);
    }

    protected boolean isValid() {
        if (!this.p.isOnline() || !this.p.isValid() || this.p.isDead() || !this.p.isSneaking()) {
            this.cancel();
            return false;
        }
        return true;
    }

    protected abstract void executeTask();
}

