/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;

final class StartupWarnings {
    private static final String BORDER = "****************************************************";
    private static final String PREFIX = "* ";

    private StartupWarnings() {
    }

    @ParametersAreNonnullByDefault
    static void discourageCSCoreLib(Logger logger) {
        logger.log(Level.WARNING, BORDER);
        logger.log(Level.WARNING, "* It looks like you are still using CS-CoreLib.");
        logger.log(Level.WARNING, PREFIX);
        logger.log(Level.WARNING, "* Slimefun no longer requires CS-CoreLib to be");
        logger.log(Level.WARNING, "* installed as of January 30th 2021. It is safe");
        logger.log(Level.WARNING, "* to remove and we recommend you to uninstall");
        logger.log(Level.WARNING, "* CS-CoreLib from your server immediately.");
        logger.log(Level.WARNING, BORDER);
    }

    @ParametersAreNonnullByDefault
    static void invalidMinecraftVersion(Logger logger, int majorVersion, String slimefunVersion) {
        logger.log(Level.SEVERE, BORDER);
        logger.log(Level.SEVERE, "* Slimefun was not installed correctly!");
        logger.log(Level.SEVERE, "* You are using the wrong version of Minecraft!");
        logger.log(Level.SEVERE, PREFIX);
        logger.log(Level.SEVERE, "* You are using Minecraft 1.{0}.x", majorVersion);
        logger.log(Level.SEVERE, "* but Slimefun {0} requires you to be using", slimefunVersion);
        logger.log(Level.SEVERE, "* Minecraft {0}", String.join((CharSequence)" / ", SlimefunPlugin.getSupportedVersions()));
        logger.log(Level.SEVERE, BORDER);
    }

    @ParametersAreNonnullByDefault
    static void invalidServerSoftware(Logger logger) {
        logger.log(Level.SEVERE, BORDER);
        logger.log(Level.SEVERE, "* Slimefun was not installed correctly!");
        logger.log(Level.SEVERE, "* CraftBukkit is no longer supported!");
        logger.log(Level.SEVERE, PREFIX);
        logger.log(Level.SEVERE, "* Slimefun requires you to use Spigot, Paper or");
        logger.log(Level.SEVERE, "* any supported fork of Spigot or Paper.");
        logger.log(Level.SEVERE, "* (We recommend Paper)");
        logger.log(Level.SEVERE, BORDER);
    }

    @ParametersAreNonnullByDefault
    static void oldJavaVersion(Logger logger) {
        int javaVersion = NumberUtils.getJavaVersion();
        logger.log(Level.WARNING, BORDER);
        logger.log(Level.WARNING, "* Your Java version (Java {0}) is out of date.", javaVersion);
        logger.log(Level.WARNING, PREFIX);
        logger.log(Level.WARNING, "* We recommend you to update to Java 16.");
        logger.log(Level.WARNING, "* Java 16 is required as of Minecraft 1.17 and");
        logger.log(Level.WARNING, "* we would like to utilise all the new features");
        logger.log(Level.WARNING, "* that come with it as soon as possible.");
        logger.log(Level.WARNING, "* Slimefun will also require Java 16 in");
        logger.log(Level.WARNING, "* the foreseeable future, so please update!");
        logger.log(Level.WARNING, BORDER);
    }
}

