/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.weapons;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.core.handlers.WeaponUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.inventory.ItemStack;

public class VampireBlade
extends SimpleSlimefunItem<WeaponUseHandler> {
    private static final double HEALING_AMOUNT = 4.0;
    private final ItemSetting<Integer> chance = new IntRangeSetting(this, "chance", 0, 45, 100);

    @ParametersAreNonnullByDefault
    public VampireBlade(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.chance);
    }

    @Override
    @Nonnull
    public WeaponUseHandler getItemHandler() {
        return (e, p, item) -> {
            if (ThreadLocalRandom.current().nextInt(100) < this.getChance()) {
                p.playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 0.7f, 0.7f);
                double health = p.getHealth() + 4.0;
                double maxHealth = p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                p.setHealth(Math.min(health, maxHealth));
            }
        };
    }

    public int getChance() {
        return this.chance.getValue();
    }
}

