/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSpawnReason;
import io.github.thebusybiscuit.slimefun4.core.handlers.ToolUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.blocks.AbstractMonsterSpawner;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class PickaxeOfContainment
extends SimpleSlimefunItem<ToolUseHandler> {
    @ParametersAreNonnullByDefault
    public PickaxeOfContainment(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    @Nonnull
    public ToolUseHandler getItemHandler() {
        return (e, tool, fortune, drops) -> {
            Block b = e.getBlock();
            if (b.getType() == Material.SPAWNER) {
                ItemStack spawner = this.breakSpawner(b);
                SlimefunUtils.spawnItem(b.getLocation(), spawner, ItemSpawnReason.BROKEN_SPAWNER_DROP, true);
                e.setExpToDrop(0);
                e.setDropItems(false);
            }
        };
    }

    @Nonnull
    private ItemStack breakSpawner(@Nonnull Block b) {
        AbstractMonsterSpawner spawner = BlockStorage.hasBlockInfo(b) ? (AbstractMonsterSpawner)SlimefunItems.REPAIRED_SPAWNER.getItem() : (AbstractMonsterSpawner)SlimefunItems.BROKEN_SPAWNER.getItem();
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof CreatureSpawner) {
            EntityType entityType = ((CreatureSpawner)state).getSpawnedType();
            return spawner.getItemForEntityType(entityType);
        }
        return new ItemStack(Material.SPAWNER);
    }
}

