/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class PickaxeOfTheSeeker
extends SimpleSlimefunItem<ItemUseHandler>
implements DamageableItem {
    private final ItemSetting<Integer> maxRange = new IntRangeSetting(this, "max-range", 1, 5, Integer.MAX_VALUE);

    @ParametersAreNonnullByDefault
    public PickaxeOfTheSeeker(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.maxRange);
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            Block closest = this.findClosestOre(p);
            e.setUseBlock(Event.Result.DENY);
            if (closest == null) {
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.pickaxe-of-the-seeker.no-ores");
            } else {
                double l = (double)closest.getX() + 0.5 - p.getLocation().getX();
                double w = (double)closest.getZ() + 0.5 - p.getLocation().getZ();
                double c = Math.sqrt(l * l + w * w);
                float alpha1 = (float)(-(Math.asin(l / c) / Math.PI * 180.0));
                float alpha2 = (float)(Math.acos(w / c) / Math.PI * 180.0);
                float yaw = alpha2 > 90.0f ? 180.0f - alpha1 : alpha1;
                float pitch = (float)(-Math.atan(((double)closest.getY() - 0.5 - p.getLocation().getY()) / Math.sqrt(l * l + w * w)) * 180.0 / Math.PI);
                Location loc = new Location(p.getWorld(), p.getLocation().getX(), p.getLocation().getY(), p.getLocation().getZ(), yaw, pitch);
                p.teleport(loc);
            }
            this.damageItem(p, e.getItem());
        };
    }

    @Nullable
    private Block findClosestOre(@Nonnull Player p) {
        Block start = p.getLocation().getBlock();
        Block closest = null;
        double lastDistance = Double.MAX_VALUE;
        int range = this.maxRange.getValue();
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Block block = start.getRelative(x, y, z);
                    if (!SlimefunTag.PICKAXE_OF_THE_SEEKER_BLOCKS.isTagged(block.getType())) continue;
                    double distance = block.getLocation().distanceSquared(start.getLocation());
                    if (closest != null && !(distance < lastDistance)) continue;
                    closest = block;
                    lastDistance = distance;
                }
            }
        }
        return closest;
    }

    @Override
    public boolean isDamageable() {
        return true;
    }
}

