/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetProvider;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.HashSet;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class DebugFishListener
implements Listener {
    private final String greenCheckmark;
    private final String redCross;

    public DebugFishListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.greenCheckmark = "&2\u2714";
        this.redCross = "&4\u2718";
    }

    @EventHandler
    public void onDebug(PlayerInteractEvent e) {
        if (e.getAction() == Action.PHYSICAL || e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player p = e.getPlayer();
        if (SlimefunUtils.isItemSimilar(e.getItem(), SlimefunItems.DEBUG_FISH, true, false)) {
            e.setCancelled(true);
            if (p.hasPermission("slimefun.debugging")) {
                if (e.getAction() == Action.LEFT_CLICK_BLOCK) {
                    this.onLeftClick(p, e.getClickedBlock(), e);
                } else if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
                    this.onRightClick(p, e.getClickedBlock(), e.getBlockFace());
                }
            } else {
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.no-permission", true);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void onLeftClick(Player p, Block b, PlayerInteractEvent e) {
        if (p.isSneaking()) {
            if (BlockStorage.hasBlockInfo(b)) {
                BlockStorage.clearBlockInfo(b);
            }
        } else {
            e.setCancelled(false);
        }
    }

    @ParametersAreNonnullByDefault
    private void onRightClick(Player p, Block b, BlockFace face) {
        if (p.isSneaking()) {
            SlimefunPlugin.runSync(() -> {
                Block block = b.getRelative(face);
                block.setType(Material.PLAYER_HEAD);
                SkullBlock.setFromHash(block, HeadTexture.MISSING_TEXTURE.getTexture());
                p.playSound(block.getLocation(), Sound.BLOCK_BAMBOO_PLACE, 1.0f, 1.0f);
            }, 2L);
        } else if (BlockStorage.hasBlockInfo(b)) {
            try {
                this.sendInfo(p, b);
            }
            catch (Exception x) {
                SlimefunPlugin.logger().log(Level.SEVERE, "An Exception occurred while using a Debug-Fish", x);
            }
        } else {
            HashSet<SlimefunTag> tags = new HashSet<SlimefunTag>();
            for (SlimefunTag tag : SlimefunTag.values()) {
                if (!tag.isTagged(b.getType())) continue;
                tags.add(tag);
            }
            if (!tags.isEmpty()) {
                p.sendMessage(" ");
                p.sendMessage(ChatColors.color("&dSlimefun tags for: &e") + b.getType().name());
                for (SlimefunTag tag : tags) {
                    p.sendMessage(ChatColors.color("&d* &e") + tag.name());
                }
                p.sendMessage(" ");
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void sendInfo(Player p, Block b) {
        SlimefunItem item = BlockStorage.check(b);
        p.sendMessage(" ");
        p.sendMessage(ChatColors.color("&d" + b.getType() + " &e@ X: " + b.getX() + " Y: " + b.getY() + " Z: " + b.getZ()));
        p.sendMessage(ChatColors.color("&dId: &e" + item.getId()));
        p.sendMessage(ChatColors.color("&dPlugin: &e" + item.getAddon().getName()));
        if (b.getState() instanceof Skull) {
            p.sendMessage(ChatColors.color("&dSkull: " + this.greenCheckmark));
            if (b.getType() == Material.PLAYER_WALL_HEAD) {
                p.sendMessage(ChatColors.color("  &dFacing: &e" + ((Directional)b.getBlockData()).getFacing().toString()));
            } else {
                p.sendMessage(ChatColors.color("  &dRotation: &e" + ((Rotatable)b.getBlockData()).getRotation().toString()));
            }
        }
        if (BlockStorage.getStorage(b.getWorld()).hasInventory(b.getLocation())) {
            p.sendMessage(ChatColors.color("&dInventory: " + this.greenCheckmark));
        } else {
            p.sendMessage(ChatColors.color("&dInventory: " + this.redCross));
        }
        if (item.isTicking()) {
            p.sendMessage(ChatColors.color("&dTicking: " + this.greenCheckmark));
            p.sendMessage(ChatColors.color("  &dAsync: &e" + (item.getBlockTicker().isSynchronized() ? this.redCross : this.greenCheckmark)));
        } else if (item instanceof EnergyNetProvider) {
            p.sendMessage(ChatColors.color("&dTicking: &3Indirect (Generator)"));
        } else {
            p.sendMessage(ChatColors.color("&dTicking: " + this.redCross));
        }
        if (SlimefunPlugin.getProfiler().hasTimings(b)) {
            p.sendMessage(ChatColors.color("  &dTimings: &e" + SlimefunPlugin.getProfiler().getTime(b)));
            p.sendMessage(ChatColors.color("  &dTotal Timings: &e" + SlimefunPlugin.getProfiler().getTime(item)));
            p.sendMessage(ChatColors.color("  &dChunk Timings: &e" + SlimefunPlugin.getProfiler().getTime(b.getChunk())));
        }
        if (item instanceof EnergyNetComponent) {
            EnergyNetComponent component = (EnergyNetComponent)((Object)item);
            p.sendMessage(ChatColors.color("&dEnergyNet Component"));
            p.sendMessage(ChatColors.color("  &dType: &e" + (Object)((Object)component.getEnergyComponentType())));
            if (component.isChargeable()) {
                p.sendMessage(ChatColors.color("  &dChargeable: " + this.greenCheckmark));
                p.sendMessage(ChatColors.color("  &dEnergy: &e" + component.getCharge(b.getLocation()) + " / " + component.getCapacity()));
            } else {
                p.sendMessage(ChatColors.color("&dChargeable: " + this.redCross));
            }
        }
        p.sendMessage(ChatColors.color("&6" + BlockStorage.getBlockInfoAsJson(b)));
        p.sendMessage(" ");
    }
}

