/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.integrations;

import com.gmail.nossr50.events.skills.salvage.McMMOPlayerSalvageCheckEvent;
import com.gmail.nossr50.mcMMO;
import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.VanillaItem;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

class McMMOIntegration
implements Listener {
    private final SlimefunPlugin plugin;

    McMMOIntegration(@Nonnull SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public void register() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
        try {
            mcMMO.getPlaceStore().setTrue(e.getBlock());
        }
        catch (Exception | LinkageError x) {
            SlimefunPlugin.getIntegrations().logError("mcMMO", x);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onItemSalvage(McMMOPlayerSalvageCheckEvent e) {
        if (!this.isSalvageable(e.getSalvageItem())) {
            e.setCancelled(true);
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)e.getPlayer(), "anvil.mcmmo-salvaging");
        }
    }

    private boolean isSalvageable(@Nonnull ItemStack item) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        return sfItem == null || sfItem instanceof VanillaItem;
    }
}

