/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.operations;

import io.github.thebusybiscuit.slimefun4.core.machines.MachineOperation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public class FuelOperation
implements MachineOperation {
    private final ItemStack ingredient;
    private final ItemStack result;
    private final int totalTicks;
    private int currentTicks = 0;

    public FuelOperation(@Nonnull MachineFuel recipe) {
        this(recipe.getInput(), recipe.getOutput(), recipe.getTicks());
    }

    public FuelOperation(@Nonnull ItemStack ingredient, @Nullable ItemStack result, int totalTicks) {
        Validate.notNull((Object)ingredient, (String)"The Ingredient cannot be null");
        Validate.isTrue((totalTicks > 0 ? 1 : 0) != 0, (String)"The amount of total ticks must be a positive integer");
        this.ingredient = ingredient;
        this.result = result;
        this.totalTicks = totalTicks;
    }

    @Override
    public void addProgress(int num) {
        Validate.isTrue((num > 0 ? 1 : 0) != 0, (String)"Progress must be positive.");
        this.currentTicks += num;
    }

    @Nonnull
    public ItemStack getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public ItemStack getResult() {
        return this.result;
    }

    @Override
    public int getProgress() {
        return this.currentTicks;
    }

    @Override
    public int getTotalTicks() {
        return this.totalTicks;
    }
}

