/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.exceptions.PrematureCodeException;
import io.github.thebusybiscuit.slimefun4.core.attributes.Radioactive;
import io.github.thebusybiscuit.slimefun4.core.attributes.Soulbound;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.CapacitorTextureUpdateTask;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.item.ImmutableItemMeta;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullItem;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public final class SlimefunUtils {
    private static final String NO_PICKUP_METADATA = "no_pickup";
    private static final String SOULBOUND_LORE = ChatColor.GRAY + "Soulbound";

    private SlimefunUtils() {
    }

    public static boolean hasNoPickupFlag(@Nonnull Item item) {
        return item.hasMetadata(NO_PICKUP_METADATA);
    }

    public static void markAsNoPickup(@Nonnull Item item, @Nonnull String context) {
        item.setMetadata(NO_PICKUP_METADATA, (MetadataValue)new FixedMetadataValue((Plugin)SlimefunPlugin.instance(), (Object)context));
    }

    public static boolean isSoulbound(@Nullable ItemStack item) {
        return SlimefunUtils.isSoulbound(item, null);
    }

    public static boolean isSoulbound(@Nullable ItemStack item, @Nullable World world) {
        if (item != null && item.getType() != Material.AIR) {
            ItemMeta meta;
            ItemMeta itemMeta = meta = item.hasItemMeta() ? item.getItemMeta() : null;
            if (SlimefunUtils.hasSoulboundFlag(meta)) {
                return true;
            }
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            if (sfItem instanceof Soulbound) {
                if (world != null) {
                    return !sfItem.isDisabledIn(world);
                }
                return !sfItem.isDisabled();
            }
            if (meta != null) {
                return meta.hasLore() && meta.getLore().contains(SOULBOUND_LORE);
            }
        }
        return false;
    }

    private static boolean hasSoulboundFlag(@Nullable ItemMeta meta) {
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            NamespacedKey key = SlimefunPlugin.getRegistry().getSoulboundDataKey();
            return container.has(key, PersistentDataType.BYTE);
        }
        return false;
    }

    public static void setSoulbound(@Nullable ItemStack item, boolean makeSoulbound) {
        List lore;
        if (item == null || item.getType() == Material.AIR) {
            throw new IllegalArgumentException("A soulbound item cannot be null or air!");
        }
        boolean isSoulbound = SlimefunUtils.isSoulbound(item);
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey key = SlimefunPlugin.getRegistry().getSoulboundDataKey();
        if (makeSoulbound && !isSoulbound) {
            container.set(key, PersistentDataType.BYTE, (Object)1);
        }
        if (!makeSoulbound && isSoulbound) {
            container.remove(key);
        }
        List list = lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        if (makeSoulbound && !isSoulbound) {
            lore.add(SOULBOUND_LORE);
        }
        if (!makeSoulbound && isSoulbound) {
            lore.remove(SOULBOUND_LORE);
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    public static boolean isRadioactive(@Nullable ItemStack item) {
        return SlimefunItem.getByItem(item) instanceof Radioactive;
    }

    @Nonnull
    public static ItemStack getCustomHead(@Nonnull String texture) {
        Validate.notNull((Object)texture, (String)"The provided texture is null");
        if (SlimefunPlugin.instance() == null) {
            throw new PrematureCodeException("You cannot instantiate a custom head before Slimefun was loaded.");
        }
        if (SlimefunPlugin.getMinecraftVersion() == MinecraftVersion.UNIT_TEST) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
        String base64 = texture;
        if (PatternUtils.HEXADECIMAL.matcher(texture).matches()) {
            base64 = Base64.getEncoder().encodeToString(("{\"textures\":{\"SKIN\":{\"url\":\"http://textures.minecraft.net/texture/" + texture + "\"}}}").getBytes(StandardCharsets.UTF_8));
        }
        return SkullItem.fromBase64(base64);
    }

    public static boolean containsSimilarItem(Inventory inventory, ItemStack item, boolean checkLore) {
        if (inventory == null || item == null) {
            return false;
        }
        if (!(item instanceof SlimefunItemStack)) {
            item = ItemStackWrapper.wrap(item);
        }
        for (ItemStack stack : inventory.getStorageContents()) {
            if (stack == null || stack.getType() == Material.AIR || !SlimefunUtils.isItemSimilar(stack, item, checkLore, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemSimilar(@Nullable ItemStack item, @Nullable ItemStack sfitem, boolean checkLore) {
        return SlimefunUtils.isItemSimilar(item, sfitem, checkLore, true);
    }

    public static boolean isItemSimilar(@Nullable ItemStack item, @Nullable ItemStack sfitem, boolean checkLore, boolean checkAmount) {
        if (item == null) {
            return sfitem == null;
        }
        if (sfitem == null) {
            return false;
        }
        if (item.getType() != sfitem.getType()) {
            return false;
        }
        if (checkAmount && item.getAmount() < sfitem.getAmount()) {
            return false;
        }
        if (sfitem instanceof SlimefunItemStack && item instanceof SlimefunItemStack) {
            return ((SlimefunItemStack)item).getItemId().equals(((SlimefunItemStack)sfitem).getItemId());
        }
        if (item.hasItemMeta()) {
            ItemMeta itemMeta = item.getItemMeta();
            if (sfitem instanceof SlimefunItemStack) {
                Optional<String> id = SlimefunPlugin.getItemDataService().getItemData(itemMeta);
                if (id.isPresent()) {
                    return id.get().equals(((SlimefunItemStack)sfitem).getItemId());
                }
                ImmutableItemMeta meta = ((SlimefunItemStack)sfitem).getImmutableMeta();
                return SlimefunUtils.equalsItemMeta(itemMeta, meta, checkLore);
            }
            if (sfitem.hasItemMeta()) {
                return SlimefunUtils.equalsItemMeta(itemMeta, sfitem.getItemMeta(), checkLore);
            }
            return false;
        }
        return !sfitem.hasItemMeta();
    }

    private static boolean equalsItemMeta(@Nonnull ItemMeta itemMeta, @Nonnull ImmutableItemMeta meta, boolean checkLore) {
        Optional<String> displayName = meta.getDisplayName();
        if (itemMeta.hasDisplayName() != displayName.isPresent()) {
            return false;
        }
        if (itemMeta.hasDisplayName() && displayName.isPresent() && !itemMeta.getDisplayName().equals(displayName.get())) {
            return false;
        }
        if (!checkLore) {
            return true;
        }
        Optional<List<String>> itemLore = meta.getLore();
        if (itemMeta.hasLore() && itemLore.isPresent()) {
            return SlimefunUtils.equalsLore(itemMeta.getLore(), itemLore.get());
        }
        return !itemMeta.hasLore() && !itemLore.isPresent();
    }

    private static boolean equalsItemMeta(@Nonnull ItemMeta itemMeta, @Nonnull ItemMeta sfitemMeta, boolean checkLore) {
        if (itemMeta.hasDisplayName() != sfitemMeta.hasDisplayName()) {
            return false;
        }
        if (itemMeta.hasDisplayName() && sfitemMeta.hasDisplayName() && !itemMeta.getDisplayName().equals(sfitemMeta.getDisplayName())) {
            return false;
        }
        if (!checkLore) {
            return true;
        }
        if (itemMeta.hasLore() && sfitemMeta.hasLore()) {
            return SlimefunUtils.equalsLore(itemMeta.getLore(), sfitemMeta.getLore());
        }
        return !itemMeta.hasLore() && !sfitemMeta.hasLore();
    }

    public static boolean equalsLore(@Nonnull List<String> lore1, @Nonnull List<String> lore2) {
        Validate.notNull(lore1, (String)"Cannot compare lore that is null!");
        Validate.notNull(lore2, (String)"Cannot compare lore that is null!");
        List<String> longerList = lore1.size() > lore2.size() ? lore1 : lore2;
        List<String> shorterList = lore1.size() > lore2.size() ? lore2 : lore1;
        int b = 0;
        for (int a = 0; a < longerList.size(); ++a) {
            if (SlimefunUtils.isLineIgnored(longerList.get(a))) continue;
            while (shorterList.size() > b && SlimefunUtils.isLineIgnored(shorterList.get(b))) {
                ++b;
            }
            if (b >= shorterList.size()) {
                return false;
            }
            if (longerList.get(a).equals(shorterList.get(b))) {
                ++b;
                continue;
            }
            return false;
        }
        while (shorterList.size() > b && SlimefunUtils.isLineIgnored(shorterList.get(b))) {
            ++b;
        }
        return b == shorterList.size();
    }

    private static boolean isLineIgnored(@Nonnull String line) {
        return line.equals(SOULBOUND_LORE);
    }

    public static void updateCapacitorTexture(@Nonnull Location l, int charge, int capacity) {
        Validate.notNull((Object)l, (String)"Cannot update a texture for null");
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"Capacity must be greater than zero!");
        SlimefunPlugin.runSync(new CapacitorTextureUpdateTask(l, charge, capacity));
    }

    public static boolean canPlayerUseItem(@Nonnull Player p, @Nullable ItemStack item, boolean sendMessage) {
        Validate.notNull((Object)p, (String)"The player cannot be null");
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem != null) {
            return sfItem.canUse(p, sendMessage);
        }
        return true;
    }
}

