/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public final class ChargeUtils {
    private static final String LORE_PREFIX = ChatColors.color("&8\u21e8 &e\u26a1 &7");
    private static final Pattern REGEX = Pattern.compile(ChatColors.color("(&c&o)?" + LORE_PREFIX) + "[0-9.]+ / [0-9.]+ J");

    private ChargeUtils() {
    }

    public static void setCharge(@Nonnull ItemMeta meta, float charge, float capacity) {
        Validate.notNull((Object)meta, (String)"Meta cannot be null!");
        Validate.isTrue((charge >= 0.0f ? 1 : 0) != 0, (String)"Charge has to be equal to or greater than 0!");
        Validate.isTrue((capacity > 0.0f ? 1 : 0) != 0, (String)"Capacity has to be greater than 0!");
        Validate.isTrue((charge <= capacity ? 1 : 0) != 0, (String)"Charge may not be bigger than the capacity!");
        BigDecimal decimal = BigDecimal.valueOf(charge).setScale(2, RoundingMode.HALF_UP);
        float value = decimal.floatValue();
        NamespacedKey key = SlimefunPlugin.getRegistry().getItemChargeDataKey();
        meta.getPersistentDataContainer().set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(value));
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        for (int i = 0; i < lore.size(); ++i) {
            String line = (String)lore.get(i);
            if (!REGEX.matcher(line).matches()) continue;
            lore.set(i, LORE_PREFIX + value + " / " + capacity + " J");
            meta.setLore(lore);
            return;
        }
        lore.add(LORE_PREFIX + value + " / " + capacity + " J");
        meta.setLore(lore);
    }

    public static float getCharge(@Nonnull ItemMeta meta) {
        Validate.notNull((Object)meta, (String)"Meta cannot be null!");
        NamespacedKey key = SlimefunPlugin.getRegistry().getItemChargeDataKey();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        Float value = (Float)container.get(key, PersistentDataType.FLOAT);
        if (value != null) {
            return value.floatValue();
        }
        if (meta.hasLore()) {
            for (String line : meta.getLore()) {
                if (!REGEX.matcher(line).matches()) continue;
                String data = ChatColor.stripColor((String)PatternUtils.SLASH_SEPARATOR.split(line)[0].replace(LORE_PREFIX, ""));
                float loreValue = Float.parseFloat(data);
                container.set(key, PersistentDataType.FLOAT, (Object)Float.valueOf(loreValue));
                return loreValue;
            }
        }
        return 0.0f;
    }
}

