/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.github;

import io.github.thebusybiscuit.slimefun4.core.services.github.GitHubService;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.GetRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpResponse;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonNode;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Unirest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.json.JSONException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class GitHubConnector {
    private static final String API_URL = "https://api.github.com/";
    private static final String USER_AGENT = "Slimefun4 (https://github.com/Slimefun)";
    protected final GitHubService github;
    private final String url;
    private File file;

    GitHubConnector(@Nonnull GitHubService github, @Nonnull String repository) {
        this.github = github;
        this.url = "https://api.github.com/repos/" + repository + this.getEndpoint();
    }

    @Nonnull
    public abstract String getFileName();

    @Nonnull
    public abstract String getEndpoint();

    @Nonnull
    public abstract Map<String, Object> getParameters();

    public abstract void onSuccess(@Nonnull JsonNode var1);

    public void onFailure() {
    }

    void download() {
        this.file = new File("plugins/Slimefun/cache/github/" + this.getFileName() + ".json");
        if (this.github.isLoggingEnabled()) {
            SlimefunPlugin.logger().log(Level.INFO, "Retrieving {0}.json from GitHub...", this.getFileName());
        }
        try {
            HttpResponse<JsonNode> response = ((GetRequest)((GetRequest)Unirest.get(this.url).queryString(this.getParameters())).header("User-Agent", USER_AGENT)).asJson();
            if (response.isSuccess()) {
                this.onSuccess(response.getBody());
                this.writeCacheFile(response.getBody());
            } else {
                JsonNode cache;
                if (this.github.isLoggingEnabled()) {
                    SlimefunPlugin.logger().log(Level.WARNING, "Failed to fetch {0}: {1} - {2}", new Object[]{this.url, response.getStatus(), response.getBody()});
                }
                if (this.file.exists() && (cache = this.readCacheFile()) != null) {
                    this.onSuccess(cache);
                }
            }
        }
        catch (UnirestException e) {
            JsonNode cache;
            if (this.github.isLoggingEnabled()) {
                SlimefunPlugin.logger().log(Level.WARNING, "Could not connect to GitHub in time.", e);
            }
            if (this.file.exists() && (cache = this.readCacheFile()) != null) {
                this.onSuccess(cache);
                return;
            }
            this.onFailure();
        }
    }

    @Nullable
    private JsonNode readCacheFile() {
        JsonNode jsonNode;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
        try {
            jsonNode = new JsonNode(reader.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JSONException | IOException e) {
                SlimefunPlugin.logger().log(Level.WARNING, "Failed to read Github cache file: {0} - {1}: {2}", new Object[]{this.file.getName(), e.getClass().getSimpleName(), e.getMessage()});
                return null;
            }
        }
        reader.close();
        return jsonNode;
    }

    private void writeCacheFile(@Nonnull JsonNode node) {
        try (FileOutputStream output = new FileOutputStream(this.file);){
            output.write(node.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            SlimefunPlugin.logger().log(Level.WARNING, "Failed to populate GitHub cache: {0} - {1}", new Object[]{e.getClass().getSimpleName(), e.getMessage()});
        }
    }
}

