/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.researching;

import io.github.thebusybiscuit.slimefun4.api.events.ResearchUnlockEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.options.SlimefunGuideSettings;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.FireworkUtils;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerResearchTask
implements Consumer<PlayerProfile> {
    private static final int[] RESEARCH_PROGRESS = new int[]{23, 44, 57, 92};
    private static final String PLACEHOLDER = "%research%";
    private final Research research;
    private final boolean isInstant;
    private final Consumer<Player> callback;

    PlayerResearchTask(@Nonnull Research research, boolean isInstant, @Nullable Consumer<Player> callback) {
        Validate.notNull((Object)research, (String)"The Research must not be null");
        this.research = research;
        this.isInstant = isInstant;
        this.callback = callback;
    }

    @Override
    public void accept(PlayerProfile profile) {
        if (!profile.hasUnlocked(this.research)) {
            Player p = profile.getPlayer();
            if (p == null) {
                return;
            }
            if (!this.isInstant) {
                SlimefunPlugin.runSync(() -> {
                    p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> msg.replace(PLACEHOLDER, this.research.getName(p)).replace("%progress%", "0%"));
                }, 5L);
            }
            ResearchUnlockEvent event = new ResearchUnlockEvent(p, this.research);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                if (this.isInstant) {
                    SlimefunPlugin.runSync(() -> this.unlockResearch(p, profile));
                } else if (SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().add(p.getUniqueId())) {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.research.start", true, msg -> msg.replace(PLACEHOLDER, this.research.getName(p)));
                    this.sendUpdateMessage(p);
                    SlimefunPlugin.runSync(() -> {
                        this.unlockResearch(p, profile);
                        SlimefunPlugin.getRegistry().getCurrentlyResearchingPlayers().remove(p.getUniqueId());
                    }, (long)(RESEARCH_PROGRESS.length + 1) * 20L);
                }
            }
        }
    }

    private void sendUpdateMessage(@Nonnull Player p) {
        for (int i = 1; i < RESEARCH_PROGRESS.length + 1; ++i) {
            int index = i;
            SlimefunPlugin.runSync(() -> {
                p.playSound(p.getLocation(), Sound.ENTITY_BAT_TAKEOFF, 0.7f, 1.0f);
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.research.progress", true, msg -> {
                    String progress = RESEARCH_PROGRESS[index - 1] + "%";
                    return msg.replace(PLACEHOLDER, this.research.getName(p)).replace("%progress%", progress);
                });
            }, (long)i * 20L);
        }
    }

    private void unlockResearch(@Nonnull Player p, @Nonnull PlayerProfile profile) {
        profile.setResearched(this.research, true);
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.unlocked", true, msg -> msg.replace(PLACEHOLDER, this.research.getName(p)));
        this.onFinish(p);
        if (SlimefunPlugin.getRegistry().isResearchFireworkEnabled() && SlimefunGuideSettings.hasFireworksEnabled(p)) {
            FireworkUtils.launchRandom((Entity)p, 1);
        }
    }

    private void onFinish(@Nonnull Player p) {
        if (this.callback != null) {
            this.callback.accept(p);
        }
    }
}

