/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;

public class QueryParams {
    private final Collection<NameValuePair> pairs = new ArrayList<NameValuePair>();

    public static QueryParams fromURI(String uri) {
        return new QueryParams(uri);
    }

    public static QueryParams fromBody(String body) {
        QueryParams queryParams = new QueryParams();
        queryParams.parse(body);
        return queryParams;
    }

    private QueryParams() {
    }

    private QueryParams(String url) {
        this();
        String[] urlParts = url.split("\\?");
        if (urlParts.length > 1) {
            this.parse(urlParts[1]);
        }
    }

    private void parse(String urlPart) {
        try {
            String query = urlPart;
            for (String param : query.split("&")) {
                String[] pair = param.split("=");
                String key = URLDecoder.decode(pair[0], "UTF-8");
                String value = "";
                if (pair.length > 1) {
                    value = URLDecoder.decode(pair[1], "UTF-8");
                }
                this.pairs.add(new NameValuePair(key, value));
            }
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
    }

    public Collection<NameValuePair> getQueryParams() {
        return new ArrayList<NameValuePair>(this.pairs);
    }

    public static class NameValuePair {
        private final String key;
        private final String value;

        public NameValuePair(String name, String value) {
            this.key = name;
            this.value = value;
        }

        public String getName() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

