/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideMode;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlock;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.guide.CheatSheetSlimefunGuide;
import io.github.thebusybiscuit.slimefun4.implementation.guide.SurvivalSlimefunGuide;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.ItemHandler;
import me.mrCookieSlime.Slimefun.api.BlockInfoConfig;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.KeyMap;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public final class SlimefunRegistry {
    private final Map<String, SlimefunItem> slimefunIds = new HashMap<String, SlimefunItem>();
    private final List<SlimefunItem> slimefunItems = new ArrayList<SlimefunItem>();
    private final List<SlimefunItem> enabledItems = new ArrayList<SlimefunItem>();
    private final List<Category> categories = new ArrayList<Category>();
    private final List<MultiBlock> multiblocks = new LinkedList<MultiBlock>();
    private final List<Research> researches = new LinkedList<Research>();
    private final List<String> researchRanks = new ArrayList<String>();
    private final Set<UUID> researchingPlayers = Collections.synchronizedSet(new HashSet());
    private boolean backwardsCompatibility;
    private boolean automaticallyLoadItems;
    private boolean enableResearches;
    private boolean freeCreativeResearches;
    private boolean researchFireworks;
    private boolean disableLearningAnimation;
    private boolean logDuplicateBlockEntries;
    private boolean talismanActionBarMessages;
    private final Set<String> tickers = new HashSet<String>();
    private final Set<SlimefunItem> radioactive = new HashSet<SlimefunItem>();
    private final Set<ItemStack> barterDrops = new HashSet<ItemStack>();
    private NamespacedKey soulboundKey;
    private NamespacedKey itemChargeKey;
    private NamespacedKey guideKey;
    private final KeyMap<GEOResource> geoResources = new KeyMap();
    private final Map<UUID, PlayerProfile> profiles = new ConcurrentHashMap<UUID, PlayerProfile>();
    private final Map<String, BlockStorage> worlds = new ConcurrentHashMap<String, BlockStorage>();
    private final Map<String, BlockInfoConfig> chunks = new HashMap<String, BlockInfoConfig>();
    private final Map<SlimefunGuideMode, SlimefunGuideImplementation> guides = new EnumMap<SlimefunGuideMode, SlimefunGuideImplementation>(SlimefunGuideMode.class);
    private final Map<EntityType, Set<ItemStack>> mobDrops = new EnumMap<EntityType, Set<ItemStack>>(EntityType.class);
    private final Map<String, BlockMenuPreset> blockMenuPresets = new HashMap<String, BlockMenuPreset>();
    private final Map<String, UniversalBlockMenu> universalInventories = new HashMap<String, UniversalBlockMenu>();
    private final Map<Class<? extends ItemHandler>, Set<ItemHandler>> globalItemHandlers = new HashMap<Class<? extends ItemHandler>, Set<ItemHandler>>();

    public void load(@Nonnull SlimefunPlugin plugin, @Nonnull Config cfg) {
        Validate.notNull((Object)plugin, (String)"The Plugin cannot be null!");
        Validate.notNull((Object)cfg, (String)"The Config cannot be null!");
        this.soulboundKey = new NamespacedKey((Plugin)plugin, "soulbound");
        this.itemChargeKey = new NamespacedKey((Plugin)plugin, "item_charge");
        this.guideKey = new NamespacedKey((Plugin)plugin, "slimefun_guide_mode");
        boolean showVanillaRecipes = cfg.getBoolean("guide.show-vanilla-recipes");
        this.guides.put(SlimefunGuideMode.SURVIVAL_MODE, new SurvivalSlimefunGuide(showVanillaRecipes));
        this.guides.put(SlimefunGuideMode.CHEAT_MODE, new CheatSheetSlimefunGuide());
        this.researchRanks.addAll(cfg.getStringList("research-ranks"));
        this.backwardsCompatibility = cfg.getBoolean("options.backwards-compatibility");
        this.freeCreativeResearches = cfg.getBoolean("researches.free-in-creative-mode");
        this.researchFireworks = cfg.getBoolean("researches.enable-fireworks");
        this.disableLearningAnimation = cfg.getBoolean("researches.disable-learning-animation");
        this.logDuplicateBlockEntries = cfg.getBoolean("options.log-duplicate-block-entries");
        this.talismanActionBarMessages = cfg.getBoolean("talismans.use-actionbar");
    }

    public boolean isAutoLoadingEnabled() {
        return this.automaticallyLoadItems;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatibility;
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.backwardsCompatibility = compatible;
    }

    public void setAutoLoadingMode(boolean mode) {
        this.automaticallyLoadItems = mode;
    }

    @Nonnull
    public List<Category> getCategories() {
        return this.categories;
    }

    @Nonnull
    public List<SlimefunItem> getAllSlimefunItems() {
        return this.slimefunItems;
    }

    @Nonnull
    public List<SlimefunItem> getEnabledSlimefunItems() {
        return this.enabledItems;
    }

    @Nonnull
    public List<Research> getResearches() {
        return this.researches;
    }

    @Nonnull
    public Set<UUID> getCurrentlyResearchingPlayers() {
        return this.researchingPlayers;
    }

    @Nonnull
    public List<String> getResearchRanks() {
        return this.researchRanks;
    }

    public void setResearchingEnabled(boolean enabled) {
        this.enableResearches = enabled;
    }

    public boolean isResearchingEnabled() {
        return this.enableResearches;
    }

    public void setFreeCreativeResearchingEnabled(boolean enabled) {
        this.freeCreativeResearches = enabled;
    }

    public boolean isFreeCreativeResearchingEnabled() {
        return this.freeCreativeResearches;
    }

    public boolean isResearchFireworkEnabled() {
        return this.researchFireworks;
    }

    public boolean isLearningAnimationDisabled() {
        return this.disableLearningAnimation;
    }

    @Nonnull
    public List<MultiBlock> getMultiBlocks() {
        return this.multiblocks;
    }

    @Nonnull
    public SlimefunGuideImplementation getSlimefunGuide(@Nonnull SlimefunGuideMode mode) {
        Validate.notNull((Object)((Object)mode), (String)"The Guide mode cannot be null");
        SlimefunGuideImplementation guide = this.guides.get((Object)mode);
        if (guide == null) {
            throw new IllegalStateException("Slimefun Guide '" + (Object)((Object)mode) + "' has no registered implementation.");
        }
        return guide;
    }

    @Nonnull
    public Map<EntityType, Set<ItemStack>> getMobDrops() {
        return this.mobDrops;
    }

    @Nonnull
    public Set<ItemStack> getBarteringDrops() {
        return this.barterDrops;
    }

    @Nonnull
    public Set<SlimefunItem> getRadioactiveItems() {
        return this.radioactive;
    }

    @Nonnull
    public Set<String> getTickerBlocks() {
        return this.tickers;
    }

    @Nonnull
    public Map<String, SlimefunItem> getSlimefunItemIds() {
        return this.slimefunIds;
    }

    @Nonnull
    public Map<String, BlockMenuPreset> getMenuPresets() {
        return this.blockMenuPresets;
    }

    @Nonnull
    public Map<String, UniversalBlockMenu> getUniversalInventories() {
        return this.universalInventories;
    }

    @Nonnull
    public Map<UUID, PlayerProfile> getPlayerProfiles() {
        return this.profiles;
    }

    @Nonnull
    public Map<Class<? extends ItemHandler>, Set<ItemHandler>> getGlobalItemHandlers() {
        return this.globalItemHandlers;
    }

    @Nonnull
    public Set<ItemHandler> getGlobalItemHandlers(@Nonnull Class<? extends ItemHandler> identifier) {
        Validate.notNull(identifier, (String)"The identifier for an ItemHandler cannot be null!");
        return this.globalItemHandlers.computeIfAbsent(identifier, c -> new HashSet());
    }

    @Nonnull
    public Map<String, BlockStorage> getWorlds() {
        return this.worlds;
    }

    @Nonnull
    public Map<String, BlockInfoConfig> getChunks() {
        return this.chunks;
    }

    @Nonnull
    public KeyMap<GEOResource> getGEOResources() {
        return this.geoResources;
    }

    public boolean logDuplicateBlockEntries() {
        return this.logDuplicateBlockEntries;
    }

    public boolean useActionbarForTalismans() {
        return this.talismanActionBarMessages;
    }

    @Nonnull
    public NamespacedKey getSoulboundDataKey() {
        return this.soulboundKey;
    }

    @Nonnull
    public NamespacedKey getItemChargeDataKey() {
        return this.itemChargeKey;
    }

    @Nonnull
    public NamespacedKey getGuideDataKey() {
        return this.guideKey;
    }
}

