/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.weapons;

import io.github.thebusybiscuit.slimefun4.core.attributes.DamageableItem;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SeismicAxe
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable,
DamageableItem {
    private static final float STRENGTH = 1.2f;
    private static final float HEIGHT = 0.9f;
    private static final float DAMAGE = 6.0f;
    private static final float MIN_PLAYER_DISTANCE = 0.2f;
    private static final float MAX_GROUND_DISTANCE = 1.5f;
    private static final int RANGE = 10;

    @ParametersAreNonnullByDefault
    public SeismicAxe(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            int i;
            Player p = e.getPlayer();
            List blocks = p.getLineOfSight(null, 10);
            HashSet<UUID> pushedEntities = new HashSet<UUID>();
            for (i = 2; i < blocks.size(); ++i) {
                Block ground = this.findGround((Block)blocks.get(i));
                Location groundLocation = ground.getLocation();
                ground.getWorld().playEffect(groundLocation, Effect.STEP_SOUND, (Object)ground.getType());
                Block blockAbove = ground.getRelative(BlockFace.UP);
                if (blockAbove.getType().isAir()) {
                    this.createJumpingBlock(ground, blockAbove, i);
                }
                for (Entity n : ground.getChunk().getEntities()) {
                    if (!(n instanceof LivingEntity) || n.getType() == EntityType.ARMOR_STAND || n.getUniqueId().equals(p.getUniqueId()) || !this.canReach(p.getLocation(), n.getLocation(), groundLocation) || !pushedEntities.add(n.getUniqueId())) continue;
                    this.pushEntity(p, n);
                }
            }
            for (i = 0; i < 4; ++i) {
                this.damageItem(p, e.getItem());
            }
        };
    }

    @ParametersAreNonnullByDefault
    private void createJumpingBlock(Block ground, Block blockAbove, int index) {
        Location loc = ground.getRelative(BlockFace.UP).getLocation().add(0.5, 0.0, 0.5);
        FallingBlock block = ground.getWorld().spawnFallingBlock(loc, ground.getBlockData());
        block.setDropItem(false);
        block.setVelocity(new Vector(0.0, 0.4 + (double)index * 0.01, 0.0));
        block.setMetadata("seismic_axe", (MetadataValue)new FixedMetadataValue((Plugin)SlimefunPlugin.instance(), (Object)"fake_block"));
    }

    @ParametersAreNonnullByDefault
    private boolean canReach(Location playerLocation, Location entityLocation, Location groundLocation) {
        double maxGroundDistanceSquared = 2.25;
        double minPlayerDistanceSquared = 0.04000000283122063;
        return entityLocation.distanceSquared(groundLocation) < maxGroundDistanceSquared && playerLocation.distanceSquared(entityLocation) > minPlayerDistanceSquared;
    }

    @ParametersAreNonnullByDefault
    private void pushEntity(Player p, Entity entity) {
        if (entity.getType() != EntityType.PLAYER || p.getWorld().getPVP()) {
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)p, entity, EntityDamageEvent.DamageCause.ENTITY_ATTACK, 6.0);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                Vector vector = entity.getLocation().toVector().subtract(p.getLocation().toVector()).normalize();
                vector.multiply(1.2f);
                vector.setY(0.9f);
                try {
                    entity.setVelocity(vector);
                }
                catch (IllegalArgumentException x) {
                    this.error("Exception while trying to set velocity: " + vector, x);
                }
                ((LivingEntity)entity).damage(event.getDamage());
            }
        }
    }

    @Nonnull
    private Block findGround(@Nonnull Block b) {
        if (b.getType() == Material.AIR) {
            for (int y = 0; y < b.getY(); ++y) {
                Block block = b.getRelative(0, -y, 0);
                if (block.getType() == Material.AIR) continue;
                return block;
            }
        }
        return b;
    }

    @Override
    public boolean isDamageable() {
        return true;
    }
}

