/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.guide;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.guide.GuideEntry;
import io.github.thebusybiscuit.slimefun4.core.guide.SlimefunGuideImplementation;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

public class GuideHistory {
    private final PlayerProfile profile;
    private final Deque<GuideEntry<?>> queue = new LinkedList();
    private int mainMenuPage = 1;

    public GuideHistory(@Nonnull PlayerProfile profile) {
        Validate.notNull((Object)profile, (String)"Cannot create a GuideHistory without a PlayerProfile!");
        this.profile = profile;
    }

    public void clear() {
        this.queue.clear();
    }

    public void setMainMenuPage(int page) {
        Validate.isTrue((page >= 1 ? 1 : 0) != 0, (String)"page must be greater than 0!");
        this.mainMenuPage = page;
    }

    public int getMainMenuPage() {
        return this.mainMenuPage;
    }

    public void add(@Nonnull Category category, int page) {
        this.refresh(category, page);
    }

    public void add(@Nonnull ItemStack item, int page) {
        this.refresh(item, page);
    }

    public void add(@Nonnull SlimefunItem item) {
        Validate.notNull((Object)item, (String)"Cannot add a non-existing SlimefunItem to the GuideHistory!");
        this.queue.add(new GuideEntry<SlimefunItem>(item, 0));
    }

    public void add(@Nonnull String searchTerm) {
        Validate.notNull((Object)searchTerm, (String)"Cannot add an empty Search Term to the GuideHistory!");
        this.queue.add(new GuideEntry<String>(searchTerm, 0));
    }

    private <T> void refresh(@Nonnull T object, int page) {
        Validate.notNull(object, (String)"Cannot add a null Entry to the GuideHistory!");
        Validate.isTrue((page >= 0 ? 1 : 0) != 0, (String)"page must not be negative!");
        GuideEntry<?> lastEntry = this.getLastEntry(false);
        if (lastEntry != null && lastEntry.getIndexedObject().equals(object)) {
            lastEntry.setPage(page);
        } else {
            this.queue.add(new GuideEntry<T>(object, page));
        }
    }

    public int size() {
        return this.queue.size();
    }

    @Nullable
    private GuideEntry<?> getLastEntry(boolean remove) {
        if (remove && !this.queue.isEmpty()) {
            this.queue.removeLast();
        }
        return this.queue.isEmpty() ? null : this.queue.getLast();
    }

    public void openLastEntry(@Nonnull SlimefunGuideImplementation guide) {
        GuideEntry<?> entry = this.getLastEntry(false);
        this.open(guide, entry);
    }

    public void goBack(@Nonnull SlimefunGuideImplementation guide) {
        GuideEntry<?> entry = this.getLastEntry(true);
        this.open(guide, entry);
    }

    private <T> void open(@Nonnull SlimefunGuideImplementation guide, @Nullable GuideEntry<T> entry) {
        if (entry == null) {
            guide.openMainMenu(this.profile, this.mainMenuPage);
        } else if (entry.getIndexedObject() instanceof Category) {
            guide.openCategory(this.profile, (Category)entry.getIndexedObject(), entry.getPage());
        } else if (entry.getIndexedObject() instanceof SlimefunItem) {
            guide.displayItem(this.profile, (SlimefunItem)entry.getIndexedObject(), false);
        } else if (entry.getIndexedObject() instanceof ItemStack) {
            guide.displayItem(this.profile, (ItemStack)entry.getIndexedObject(), entry.getPage(), false);
        } else if (entry.getIndexedObject() instanceof String) {
            guide.openSearch(this.profile, (String)entry.getIndexedObject(), false);
        } else {
            throw new IllegalStateException("Unknown GuideHistory entry: " + entry.getIndexedObject());
        }
    }
}

