/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.thebusybiscuit.slimefun4.core.attributes.NotPlaceable;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.text.DecimalFormat;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TapeMeasure
extends SimpleSlimefunItem<ItemUseHandler>
implements NotPlaceable {
    private final NamespacedKey key = new NamespacedKey((Plugin)SlimefunPlugin.instance(), "anchor");
    private final DecimalFormat format = new DecimalFormat("##.###");

    @ParametersAreNonnullByDefault
    public TapeMeasure(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            e.cancel();
            if (e.getClickedBlock().isPresent()) {
                Block block = e.getClickedBlock().get();
                if (e.getPlayer().isSneaking()) {
                    this.setAnchor(e.getPlayer(), e.getItem(), block);
                } else {
                    this.measure(e.getPlayer(), e.getItem(), block);
                }
            }
        };
    }

    @ParametersAreNonnullByDefault
    private void setAnchor(Player p, ItemStack item, Block block) {
        ItemMeta meta = item.getItemMeta();
        JsonObject json = new JsonObject();
        json.addProperty("world", block.getWorld().getUID().toString());
        json.addProperty("x", (Number)block.getX());
        json.addProperty("y", (Number)block.getY());
        json.addProperty("z", (Number)block.getZ());
        meta.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)json.toString());
        String anchor = block.getX() + " | " + block.getY() + " | " + block.getZ();
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.anchor-set", msg -> msg.replace("%anchor%", anchor));
        item.setItemMeta(meta);
    }

    @ParametersAreNonnullByDefault
    private void measure(Player p, ItemStack item, Block block) {
        OptionalDouble distance = this.getDistance(p, item, block);
        if (distance.isPresent()) {
            p.playSound(block.getLocation(), Sound.ITEM_BOOK_PUT, 1.0f, 0.7f);
            String label = this.format.format(distance.getAsDouble());
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.distance", msg -> msg.replace("%distance%", label));
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public Optional<Location> getAnchor(Player p, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        String data = (String)meta.getPersistentDataContainer().get(this.key, PersistentDataType.STRING);
        if (data != null) {
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            UUID uuid = UUID.fromString(json.get("world").getAsString());
            if (p.getWorld().getUID().equals(uuid)) {
                int x = json.get("x").getAsInt();
                int y = json.get("y").getAsInt();
                int z = json.get("z").getAsInt();
                Location loc = new Location(p.getWorld(), (double)x, (double)y, (double)z);
                return Optional.of(loc);
            }
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.wrong-world");
            return Optional.empty();
        }
        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.tape-measure.no-anchor");
        return Optional.empty();
    }

    @ParametersAreNonnullByDefault
    public OptionalDouble getDistance(Player p, ItemStack item, Block block) {
        Optional<Location> anchor = this.getAnchor(p, item);
        if (anchor.isPresent()) {
            Location loc = anchor.get();
            return OptionalDouble.of(loc.distance(block.getLocation()));
        }
        return OptionalDouble.empty();
    }
}

