/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.accelerators.AbstractGrowthAccelerator;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Keyed;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Sapling;
import org.bukkit.inventory.ItemStack;

public class TreeGrowthAccelerator
extends AbstractGrowthAccelerator {
    private static final int ENERGY_CONSUMPTION = 24;
    private static final int RADIUS = 9;
    private static final ItemStack organicFertilizer = new ItemStackWrapper(SlimefunItems.FERTILIZER);

    public TreeGrowthAccelerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public int getCapacity() {
        return 1024;
    }

    @Override
    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (this.getCharge(b.getLocation()) >= 24) {
            for (int x = -9; x <= 9; ++x) {
                for (int z = -9; z <= 9; ++z) {
                    Sapling sapling;
                    Block block = b.getRelative(x, 0, z);
                    if (!Tag.SAPLINGS.isTagged((Keyed)block.getType()) || (sapling = (Sapling)block.getBlockData()).getStage() >= sapling.getMaximumStage() || !this.growSapling(b, block, inv, sapling)) continue;
                    return;
                }
            }
        }
    }

    private boolean growSapling(Block machine, Block block, BlockMenu inv, Sapling sapling) {
        for (int slot : this.getInputSlots()) {
            if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), organicFertilizer, false, false)) continue;
            this.removeCharge(machine.getLocation(), 24);
            sapling.setStage(sapling.getStage() + 1);
            block.setBlockData((BlockData)sapling, false);
            inv.consumeItem(slot);
            block.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, block.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
            return true;
        }
        return false;
    }
}

