/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.core.networks.NetworkManager;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoNet;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

class CargoNetworkTask
implements Runnable {
    private final NetworkManager manager;
    private final CargoNet network;
    private final Map<Location, Inventory> inventories = new HashMap<Location, Inventory>();
    private final Map<Location, Integer> inputs;
    private final Map<Integer, List<Location>> outputs;
    private final Set<Location> chestTerminalInputs;
    private final Set<Location> chestTerminalOutputs;

    @ParametersAreNonnullByDefault
    CargoNetworkTask(CargoNet network, Map<Location, Integer> inputs, Map<Integer, List<Location>> outputs, Set<Location> chestTerminalInputs, Set<Location> chestTerminalOutputs) {
        this.network = network;
        this.manager = SlimefunPlugin.getNetworkManager();
        this.inputs = inputs;
        this.outputs = outputs;
        this.chestTerminalInputs = chestTerminalInputs;
        this.chestTerminalOutputs = chestTerminalOutputs;
    }

    @Override
    public void run() {
        long timestamp = System.nanoTime();
        try {
            if (SlimefunPlugin.getIntegrations().isChestTerminalInstalled()) {
                this.network.handleItemRequests(this.inventories, this.chestTerminalInputs, this.chestTerminalOutputs);
            }
            SlimefunItem inputNode = SlimefunItems.CARGO_INPUT_NODE.getItem();
            for (Map.Entry<Location, Integer> entry : this.inputs.entrySet()) {
                long nodeTimestamp = System.nanoTime();
                Location input = entry.getKey();
                Optional<Block> attachedBlock = this.network.getAttachedBlock(input);
                attachedBlock.ifPresent(block -> this.routeItems(input, (Block)block, (Integer)entry.getValue(), this.outputs));
                timestamp += SlimefunPlugin.getProfiler().closeEntry(entry.getKey(), inputNode, nodeTimestamp);
            }
            if (SlimefunPlugin.getIntegrations().isChestTerminalInstalled()) {
                timestamp += this.network.updateTerminals(this.chestTerminalInputs);
            }
        }
        catch (Exception | LinkageError x) {
            SlimefunPlugin.logger().log(Level.SEVERE, x, () -> "An Exception was caught while ticking a Cargo network @ " + new BlockPosition(this.network.getRegulator()));
        }
        SlimefunPlugin.getProfiler().closeEntry(this.network.getRegulator(), SlimefunItems.CARGO_MANAGER.getItem(), timestamp);
    }

    @ParametersAreNonnullByDefault
    private void routeItems(Location inputNode, Block inputTarget, int frequency, Map<Integer, List<Location>> outputNodes) {
        ItemStackAndInteger slot = CargoUtils.withdraw(this.network, this.inventories, inputNode.getBlock(), inputTarget);
        if (slot == null) {
            return;
        }
        ItemStack stack = slot.getItem();
        int previousSlot = slot.getInt();
        List<Location> destinations = outputNodes.get(frequency);
        if (destinations != null) {
            stack = this.distributeItem(stack, inputNode, destinations);
        }
        if (stack != null) {
            this.insertItem(inputTarget, previousSlot, stack);
        }
    }

    @ParametersAreNonnullByDefault
    private void insertItem(Block inputTarget, int previousSlot, ItemStack item) {
        Inventory inv = this.inventories.get(inputTarget.getLocation());
        if (inv != null) {
            if (inv.getItem(previousSlot) == null) {
                inv.setItem(previousSlot, item);
            } else {
                ItemStack rest = (ItemStack)inv.addItem(new ItemStack[]{item}).get(0);
                if (rest != null && !this.manager.isItemDeletionEnabled()) {
                    inputTarget.getWorld().dropItem(inputTarget.getLocation().add(0.0, 1.0, 0.0), rest);
                }
            }
        } else {
            DirtyChestMenu menu = CargoUtils.getChestMenu(inputTarget);
            if (menu != null) {
                if (menu.getItemInSlot(previousSlot) == null) {
                    menu.replaceExistingItem(previousSlot, item);
                } else if (!this.manager.isItemDeletionEnabled()) {
                    inputTarget.getWorld().dropItem(inputTarget.getLocation().add(0.0, 1.0, 0.0), item);
                }
            }
        }
    }

    @Nullable
    @ParametersAreNonnullByDefault
    private ItemStack distributeItem(ItemStack stack, Location inputNode, List<Location> outputNodes) {
        Location output;
        Optional<Block> target;
        AbstractCollection destinations;
        ItemStack item = stack;
        Config cfg = BlockStorage.getLocationInfo(inputNode);
        boolean roundrobin = Objects.equals(cfg.getString("round-robin"), "true");
        boolean smartFill = Objects.equals(cfg.getString("smart-fill"), "true");
        if (roundrobin) {
            ArrayDeque<Location> tempDestinations = new ArrayDeque<Location>(outputNodes);
            this.roundRobinSort(inputNode, tempDestinations);
            destinations = tempDestinations;
        } else {
            destinations = new ArrayList<Location>(outputNodes);
        }
        Iterator iterator = destinations.iterator();
        while (iterator.hasNext() && (!(target = this.network.getAttachedBlock(output = (Location)iterator.next())).isPresent() || (item = CargoUtils.insert(this.network, this.inventories, output.getBlock(), target.get(), smartFill, item)) != null)) {
        }
        return item;
    }

    private void roundRobinSort(Location inputNode, Deque<Location> outputNodes) {
        int index = this.network.roundRobin.getOrDefault(inputNode, 0);
        if (index < outputNodes.size()) {
            for (int i = 0; i < index; ++i) {
                Location temp = outputNodes.removeFirst();
                outputNodes.add(temp);
            }
            ++index;
        } else {
            index = 1;
        }
        this.network.roundRobin.put(inputNode, index);
    }
}

