/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.recipes;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;

public class MinecraftRecipe<T extends Recipe> {
    private static final Set<MinecraftRecipe<?>> recipeTypes;
    public static MinecraftRecipe<ShapedRecipe> SHAPED_CRAFTING;
    public static MinecraftRecipe<ShapelessRecipe> SHAPELESS_CRAFTING;
    public static MinecraftRecipe<FurnaceRecipe> FURNACE;
    public static MinecraftRecipe<BlastingRecipe> BLAST_FURNACE;
    public static MinecraftRecipe<SmokingRecipe> SMOKER;
    public static MinecraftRecipe<CampfireRecipe> CAMPFIRE;
    public static MinecraftRecipe<StonecuttingRecipe> STONECUTTER;
    public static MinecraftRecipe<SmithingRecipe> SMITHING;
    private Material machine;
    private Class<T> recipeClass;
    private Predicate<ItemStack[]> predicate;
    private Function<T, RecipeChoice[]> inputFunction;
    private BiFunction<ItemStack[], Stream<T>, Optional<ItemStack>> outputFunction;

    @ParametersAreNonnullByDefault
    private MinecraftRecipe(String material, Class<T> recipeClass, Predicate<ItemStack[]> predicate, Function<T, RecipeChoice[]> inputFunction, BiFunction<ItemStack[], Stream<T>, Optional<ItemStack>> outputFunction) {
        try {
            this.machine = Material.valueOf((String)material);
            this.recipeClass = recipeClass;
            this.predicate = predicate;
            this.inputFunction = inputFunction;
            this.outputFunction = outputFunction;
            recipeTypes.add(this);
        }
        catch (Exception | LinkageError x) {
            System.err.println("Unable to load a Minecraft Recipe Type: " + material);
        }
    }

    protected boolean validate(@Nonnull ItemStack[] inputs) {
        return this.predicate.test(inputs);
    }

    @Nonnull
    public RecipeChoice[] getInputs(@Nonnull T recipe) {
        return this.inputFunction.apply(recipe);
    }

    @Nonnull
    public Optional<ItemStack> getOutput(@Nonnull Stream<T> stream, @Nonnull ItemStack[] inputs) {
        return this.outputFunction.apply(inputs, stream);
    }

    public static <T extends Recipe> Optional<MinecraftRecipe<? super T>> of(@NonNull T recipe) {
        if (recipe == null) {
            throw new NullPointerException("recipe is marked non-null but is null");
        }
        Class<?> recipeClass = recipe.getClass();
        return recipeTypes.stream().filter(type -> type.getRecipeClass().isAssignableFrom(recipeClass)).findAny().map(type -> type);
    }

    @Nonnull
    public static Stream<MinecraftRecipe<?>> stream() {
        return recipeTypes.stream();
    }

    public Material getMachine() {
        return this.machine;
    }

    public Class<T> getRecipeClass() {
        return this.recipeClass;
    }

    private static /* synthetic */ Optional lambda$static$32(ItemStack[] input, Stream stream) {
        return stream.filter(recipe -> recipe.getBase().test(input[0]) && recipe.getAddition().test(input[1])).findAny().map(SmithingRecipe::getResult);
    }

    private static /* synthetic */ RecipeChoice[] lambda$static$30(SmithingRecipe recipe) {
        return new RecipeChoice[]{recipe.getBase(), recipe.getAddition()};
    }

    private static /* synthetic */ boolean lambda$static$29(ItemStack[] recipe) {
        return recipe.length == 2;
    }

    private static /* synthetic */ Optional lambda$static$28(ItemStack[] input, Stream stream) {
        return stream.filter(recipe -> recipe.getInputChoice().test(input[0])).findAny().map(StonecuttingRecipe::getResult);
    }

    private static /* synthetic */ RecipeChoice[] lambda$static$26(StonecuttingRecipe recipe) {
        return new RecipeChoice[]{recipe.getInputChoice()};
    }

    private static /* synthetic */ boolean lambda$static$25(ItemStack[] recipe) {
        return recipe.length == 1;
    }

    private static /* synthetic */ Optional lambda$static$24(ItemStack[] input, Stream stream) {
        return stream.filter(recipe -> recipe.getInputChoice().test(input[0])).findAny().map(CookingRecipe::getResult);
    }

    private static /* synthetic */ RecipeChoice[] lambda$static$22(CampfireRecipe recipe) {
        return new RecipeChoice[]{recipe.getInputChoice()};
    }

    private static /* synthetic */ boolean lambda$static$21(ItemStack[] recipe) {
        return recipe.length == 1;
    }

    private static /* synthetic */ Optional lambda$static$20(ItemStack[] input, Stream stream) {
        return stream.filter(recipe -> recipe.getInputChoice().test(input[0])).findAny().map(CookingRecipe::getResult);
    }

    private static /* synthetic */ RecipeChoice[] lambda$static$18(SmokingRecipe recipe) {
        return new RecipeChoice[]{recipe.getInputChoice()};
    }

    private static /* synthetic */ boolean lambda$static$17(ItemStack[] recipe) {
        return recipe.length == 1;
    }

    private static /* synthetic */ Optional lambda$static$16(ItemStack[] input, Stream stream) {
        return stream.filter(recipe -> recipe.getInputChoice().test(input[0])).findAny().map(CookingRecipe::getResult);
    }

    private static /* synthetic */ RecipeChoice[] lambda$static$14(BlastingRecipe recipe) {
        return new RecipeChoice[]{recipe.getInputChoice()};
    }

    private static /* synthetic */ boolean lambda$static$13(ItemStack[] recipe) {
        return recipe.length == 1;
    }

    private static /* synthetic */ Optional lambda$static$12(ItemStack[] input, Stream stream) {
        return stream.filter(recipe -> recipe.getInputChoice().test(input[0])).findAny().map(recipe -> recipe.getResult());
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

