/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.events.AsyncGeneratorProcessCompleteEvent;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.handlers.SimpleBlockBreakHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.AbstractEnergyProvider;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AGenerator
extends AbstractEnergyProvider {
    public static Map<Location, MachineFuel> processing = new HashMap<Location, MachineFuel>();
    public static Map<Location, Integer> progress = new HashMap<Location, Integer>();
    private static final int[] border = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 13, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44};
    private static final int[] border_in = new int[]{9, 10, 11, 12, 18, 21, 27, 28, 29, 30};
    private static final int[] border_out = new int[]{14, 15, 16, 17, 23, 26, 32, 33, 34, 35};
    private int energyProducedPerTick = -1;
    private int energyCapacity = -1;

    @ParametersAreNonnullByDefault
    public AGenerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(item.getItemId(), this.getInventoryTitle()){

            @Override
            public void init() {
                AGenerator.this.constructMenu(this);
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.INTERACT_BLOCK);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                if (flow == ItemTransportFlow.INSERT) {
                    return AGenerator.this.getInputSlots();
                }
                return AGenerator.this.getOutputSlots();
            }
        };
        this.addItemHandler(this.onBlockBreak());
        this.registerDefaultFuelTypes();
    }

    @Nonnull
    protected BlockBreakHandler onBlockBreak() {
        return new SimpleBlockBreakHandler(){

            @Override
            public void onBlockBreak(Block b) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    inv.dropItems(b.getLocation(), AGenerator.this.getInputSlots());
                    inv.dropItems(b.getLocation(), AGenerator.this.getOutputSlots());
                }
                progress.remove(b.getLocation());
                processing.remove(b.getLocation());
            }
        };
    }

    private void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_in) {
            preset.addItem(i, ChestMenuUtils.getInputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : border_out) {
            preset.addItem(i, ChestMenuUtils.getOutputSlotTexture(), ChestMenuUtils.getEmptyClickHandler());
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, new ChestMenu.AdvancedMenuClickHandler(){

                @Override
                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                @Override
                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(22, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), ChestMenuUtils.getEmptyClickHandler());
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{24, 25};
    }

    public MachineFuel getProcessing(Location l) {
        return processing.get(l);
    }

    public boolean isProcessing(Location l) {
        return progress.containsKey(l);
    }

    @Override
    public int getGeneratedOutput(Location l, Config data) {
        BlockMenu inv = BlockStorage.getInventory(l);
        if (this.isProcessing(l)) {
            int timeleft = progress.get(l);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(inv, 22, timeleft, processing.get(l).getTicks(), this.getProgressBar());
                if (this.isChargeable()) {
                    int charge = this.getCharge(l, data);
                    if (this.getCapacity() - charge >= this.getEnergyProduction()) {
                        progress.put(l, timeleft - 1);
                        return this.getEnergyProduction();
                    }
                    return 0;
                }
                progress.put(l, timeleft - 1);
                return this.getEnergyProduction();
            }
            ItemStack fuel = processing.get(l).getInput();
            if (this.isBucket(fuel)) {
                inv.pushItem(new ItemStack(Material.BUCKET), this.getOutputSlots());
            }
            inv.replaceExistingItem(22, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
            Bukkit.getPluginManager().callEvent((Event)new AsyncGeneratorProcessCompleteEvent(l, this, this.getProcessing(l)));
            progress.remove(l);
            processing.remove(l);
            return 0;
        }
        HashMap<Integer, Integer> found = new HashMap<Integer, Integer>();
        MachineFuel fuel = this.findRecipe(inv, found);
        if (fuel != null) {
            for (Map.Entry entry : found.entrySet()) {
                inv.consumeItem((Integer)entry.getKey(), (Integer)entry.getValue());
            }
            processing.put(l, fuel);
            progress.put(l, fuel.getTicks());
        }
        return 0;
    }

    private boolean isBucket(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(item);
        return item.getType() == Material.LAVA_BUCKET || SlimefunUtils.isItemSimilar(wrapper, SlimefunItems.FUEL_BUCKET, true) || SlimefunUtils.isItemSimilar(wrapper, SlimefunItems.OIL_BUCKET, true);
    }

    private MachineFuel findRecipe(BlockMenu menu, Map<Integer, Integer> found) {
        for (MachineFuel fuel : this.fuelTypes) {
            for (int slot : this.getInputSlots()) {
                if (!fuel.test(menu.getItemInSlot(slot))) continue;
                found.put(slot, fuel.getInput().getAmount());
                return fuel;
            }
        }
        return null;
    }

    @Override
    public int getCapacity() {
        return this.energyCapacity;
    }

    @Override
    public int getEnergyProduction() {
        return this.energyProducedPerTick;
    }

    public final AGenerator setCapacity(int capacity) {
        Validate.isTrue((capacity >= 0 ? 1 : 0) != 0, (String)"The capacity cannot be negative!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    public final AGenerator setEnergyProduction(int energyProduced) {
        Validate.isTrue((energyProduced > 0 ? 1 : 0) != 0, (String)"The energy production must be greater than zero!");
        this.energyProducedPerTick = energyProduced;
        return this;
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        this.addon = addon;
        if (this.getCapacity() < 0) {
            this.warn("The capacity has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyCapacity(...)' before registering!");
        }
        if (this.getEnergyProduction() <= 0) {
            this.warn("The energy consumption has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyProduction(...)' before registering!");
        }
        if (this.getCapacity() >= 0 && this.getEnergyProduction() > 0) {
            super.register(addon);
        }
    }
}

