/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.localization.Language;
import io.github.thebusybiscuit.slimefun4.core.services.localization.SlimefunLocalization;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.NumberUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class LocalizationService
extends SlimefunLocalization {
    private static final String LANGUAGE_PATH = "language";
    private final Map<String, Language> languages = new LinkedHashMap<String, Language>();
    private final boolean translationsEnabled;
    private final SlimefunPlugin plugin;
    private final String prefix;
    private final NamespacedKey languageKey;
    private final Language defaultLanguage;

    public LocalizationService(@Nonnull SlimefunPlugin plugin, @Nullable String prefix, @Nullable String serverDefaultLanguage) {
        super(plugin);
        this.plugin = plugin;
        this.prefix = prefix;
        this.languageKey = new NamespacedKey((Plugin)plugin, LANGUAGE_PATH);
        if (serverDefaultLanguage != null) {
            this.translationsEnabled = SlimefunPlugin.getCfg().getBoolean("options.enable-translations");
            this.defaultLanguage = new Language(serverDefaultLanguage, "11b3188fd44902f72602bd7c2141f5a70673a411adb3d81862c69e536166b");
            this.defaultLanguage.setMessagesFile(this.getConfig().getConfiguration());
            this.loadEmbeddedLanguages();
            String language = this.getConfig().getString(LANGUAGE_PATH);
            if (language == null) {
                language = serverDefaultLanguage;
            }
            if (this.hasLanguage(serverDefaultLanguage)) {
                this.setLanguage(serverDefaultLanguage, !serverDefaultLanguage.equals(language));
            } else {
                this.setLanguage("en", false);
                plugin.getLogger().log(Level.WARNING, "Could not recognize the given language: \"{0}\"", serverDefaultLanguage);
            }
            SlimefunPlugin.logger().log(Level.INFO, "Available languages: {0}", String.join((CharSequence)", ", this.languages.keySet()));
            this.save();
        } else {
            this.translationsEnabled = false;
            this.defaultLanguage = null;
        }
    }

    public boolean isEnabled() {
        return this.translationsEnabled;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Nonnull
    public NamespacedKey getKey() {
        return this.languageKey;
    }

    @Override
    @Nullable
    public Language getLanguage(@Nonnull String id) {
        Validate.notNull((Object)id, (String)"The language id cannot be null");
        return this.languages.get(id);
    }

    @Override
    @Nonnull
    public Collection<Language> getLanguages() {
        return this.languages.values();
    }

    @Override
    public boolean hasLanguage(@Nonnull String id) {
        Validate.notNull((Object)id, (String)"The language id cannot be null");
        return this.containsResource("messages_" + id);
    }

    public boolean isLanguageLoaded(@Nonnull String id) {
        Validate.notNull((Object)id, (String)"The language cannot be null!");
        return this.languages.containsKey(id);
    }

    private boolean containsResource(@Nonnull String file) {
        Validate.notNull((Object)file, (String)"File name cannot be null!");
        return this.plugin.getClass().getResource("/languages/" + file + ".yml") != null;
    }

    @Override
    public Language getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public Language getLanguage(@Nonnull Player p) {
        Language lang;
        Validate.notNull((Object)p, (String)"Player cannot be null!");
        PersistentDataContainer container = p.getPersistentDataContainer();
        String language = (String)container.get(this.languageKey, PersistentDataType.STRING);
        if (language != null && (lang = this.languages.get(language)) != null) {
            return lang;
        }
        return this.getDefaultLanguage();
    }

    private void setLanguage(@Nonnull String language, boolean reset) {
        if (reset) {
            this.getConfig().clear();
        }
        this.defaultLanguage.setResearchesFile(this.streamConfigFile("researches_" + language + ".yml", null));
        this.defaultLanguage.setResourcesFile(this.streamConfigFile("resources_" + language + ".yml", null));
        this.defaultLanguage.setCategoriesFile(this.streamConfigFile("categories_" + language + ".yml", null));
        this.defaultLanguage.setRecipeTypesFile(this.streamConfigFile("recipes_" + language + ".yml", null));
        SlimefunPlugin.logger().log(Level.INFO, "Loaded language \"{0}\"", language);
        this.getConfig().setValue(LANGUAGE_PATH, language);
        String path = "/languages/messages_" + language + ".yml";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.plugin.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));){
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            this.getConfig().getConfiguration().setDefaults((Configuration)config);
        }
        catch (IOException e) {
            SlimefunPlugin.logger().log(Level.SEVERE, e, () -> "Failed to load language file: \"" + path + "\"");
        }
        this.save();
    }

    @Override
    protected void addLanguage(@Nonnull String id, @Nonnull String texture) {
        Validate.notNull((Object)id, (String)"The language id cannot be null!");
        Validate.notNull((Object)texture, (String)"The language texture cannot be null");
        if (this.hasLanguage(id)) {
            FileConfiguration messages = this.streamConfigFile("messages_" + id + ".yml", this.getConfig().getConfiguration());
            FileConfiguration researches = this.streamConfigFile("researches_" + id + ".yml", null);
            FileConfiguration resources = this.streamConfigFile("resources_" + id + ".yml", null);
            FileConfiguration categories = this.streamConfigFile("categories_" + id + ".yml", null);
            FileConfiguration recipes = this.streamConfigFile("recipes_" + id + ".yml", null);
            Language language = new Language(id, texture);
            language.setMessagesFile(messages);
            language.setResearchesFile(researches);
            language.setResourcesFile(resources);
            language.setCategoriesFile(categories);
            language.setRecipeTypesFile(recipes);
            this.languages.put(id, language);
        }
    }

    public double calculateProgress(@Nonnull Language lang) {
        Validate.notNull((Object)lang, (String)"Cannot get the language progress of null");
        Set<String> defaultKeys = this.getTotalKeys(this.languages.get("en"));
        if (defaultKeys.isEmpty()) {
            return 0.0;
        }
        Set<String> keys = this.getTotalKeys(lang);
        int matches = 0;
        for (String key : defaultKeys) {
            if (!keys.contains(key)) continue;
            ++matches;
        }
        return Math.min(NumberUtils.reparseDouble(100.0 * ((double)matches / (double)defaultKeys.size())), 100.0);
    }

    @Nonnull
    private Set<String> getTotalKeys(@Nonnull Language lang) {
        return this.getKeys(lang.getFiles());
    }

    @Nonnull
    private Set<String> getKeys(FileConfiguration ... files) {
        HashSet<String> keys = new HashSet<String>();
        for (FileConfiguration cfg : files) {
            keys.addAll(cfg.getKeys(true));
        }
        return keys;
    }

    private FileConfiguration streamConfigFile(@Nonnull String file, @Nullable FileConfiguration defaults) {
        YamlConfiguration yamlConfiguration;
        String path = "/languages/" + file;
        if (this.plugin.getClass().getResourceAsStream(path) == null) {
            return new YamlConfiguration();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.plugin.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            if (defaults != null) {
                config.setDefaults((Configuration)defaults);
            }
            yamlConfiguration = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SlimefunPlugin.logger().log(Level.SEVERE, e, () -> "Failed to load language file into memory: \"" + path + "\"");
                return null;
            }
        }
        reader.close();
        return yamlConfiguration;
    }
}

