/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.apache.commons.lang.Validate;

public class ItemSetting<T> {
    private final SlimefunItem item;
    private final String key;
    private final T defaultValue;
    private T value;

    @ParametersAreNonnullByDefault
    public ItemSetting(SlimefunItem item, String key, T defaultValue) {
        Validate.notNull((Object)item, (String)"The provided SlimefunItem must not be null!");
        Validate.notNull((Object)key, (String)"The key of an ItemSetting is not allowed to be null!");
        Validate.notNull(defaultValue, (String)"The default value of an ItemSetting is not allowed to be null!");
        this.item = item;
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public boolean validateInput(T input) {
        return input != null;
    }

    public void update(@Nonnull T newValue) {
        if (!this.validateInput(newValue)) {
            throw new IllegalArgumentException("The passed value was not valid. (Maybe null?)");
        }
        this.value = newValue;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public T getValue() {
        if (this.value != null) {
            return this.value;
        }
        this.item.warn("ItemSetting '" + this.key + "' was invoked but was not initialized yet.");
        return this.defaultValue;
    }

    @Nonnull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isType(@Nonnull Class<?> c) {
        return c.isInstance(this.defaultValue);
    }

    @Nonnull
    protected String getErrorMessage() {
        return "Only '" + this.defaultValue.getClass().getSimpleName() + "' values are allowed!";
    }

    public void reload() {
        Validate.notNull((Object)this.item, (String)"Cannot apply settings for a non-existing SlimefunItem");
        SlimefunPlugin.getItemCfg().setDefaultValue(this.item.getId() + '.' + this.getKey(), this.getDefaultValue());
        Object configuredValue = SlimefunPlugin.getItemCfg().getValue(this.item.getId() + '.' + this.getKey());
        if (this.defaultValue.getClass().isInstance(configuredValue)) {
            Object newValue = configuredValue;
            if (this.validateInput(newValue)) {
                this.value = newValue;
            } else {
                this.item.warn("We have found an invalid config setting in your Items.yml!\n  at \"" + this.item.getId() + "." + this.getKey() + "\"\n  " + configuredValue + " is not a valid input!\n" + this.getErrorMessage());
            }
        } else {
            this.value = this.defaultValue;
            String found = configuredValue == null ? "null" : configuredValue.getClass().getSimpleName();
            this.item.warn("We have found an invalid config setting in your Items.yml!\nPlease only use settings that are valid.\n  at \"" + this.item.getId() + "." + this.getKey() + "\"\n  Expected \"" + this.defaultValue.getClass().getSimpleName() + "\" but found: \"" + found + "\"");
        }
    }

    public String toString() {
        T currentValue = this.value != null ? this.value : this.defaultValue;
        return this.getClass().getSimpleName() + " {" + this.getKey() + " = " + currentValue + " (default: " + this.getDefaultValue() + ")";
    }
}

