/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.geo;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.events.GEOResourceGenerationEvent;
import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.OptionalInt;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.cscorelib2.config.Config;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ResourceManager {
    private final int[] backgroundSlots = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 44, 45, 46, 48, 49, 50, 52, 53};
    private final Config config;

    public ResourceManager(@Nonnull SlimefunPlugin plugin) {
        this.config = new Config((Plugin)plugin, "resources.yml");
    }

    void register(@Nonnull GEOResource resource) {
        Validate.notNull((Object)resource, (String)"Cannot register null as a GEO-Resource");
        Validate.notNull((Object)resource.getKey(), (String)"GEO-Resources must have a NamespacedKey which is not null");
        if (SlimefunPlugin.getRegistry().getGEOResources().containsKey(resource.getKey())) {
            throw new IllegalArgumentException("GEO-Resource \"" + resource.getKey() + "\" has already been registered!");
        }
        String key = resource.getKey().getNamespace() + '.' + resource.getKey().getKey();
        boolean enabled = this.config.getOrSetDefault(key + ".enabled", true);
        if (enabled) {
            SlimefunPlugin.getRegistry().getGEOResources().add(resource);
        }
        if (SlimefunPlugin.getMinecraftVersion() != MinecraftVersion.UNIT_TEST) {
            this.config.save();
        }
    }

    public OptionalInt getSupplies(@Nonnull GEOResource resource, @Nonnull World world, int x, int z) {
        Validate.notNull((Object)resource, (String)"Cannot get supplies for null");
        Validate.notNull((Object)world, (String)"World must not be null");
        String key = resource.getKey().toString().replace(':', '-');
        String value = BlockStorage.getChunkInfo(world, x, z, key);
        if (value != null) {
            return OptionalInt.of(Integer.parseInt(value));
        }
        return OptionalInt.empty();
    }

    public void setSupplies(@Nonnull GEOResource resource, @Nonnull World world, int x, int z, int value) {
        Validate.notNull((Object)resource, (String)"Cannot set supplies for null");
        Validate.notNull((Object)world, (String)"World cannot be null");
        String key = resource.getKey().toString().replace(':', '-');
        BlockStorage.setChunkInfo(world, x, z, key, String.valueOf(value));
    }

    private int generate(@Nonnull GEOResource resource, @Nonnull World world, int x, int z) {
        Validate.notNull((Object)resource, (String)"Cannot generate resources for null");
        Validate.notNull((Object)world, (String)"World cannot be null");
        Block block = world.getBlockAt(x << 4, 72, z << 4);
        int value = resource.getDefaultSupply(world.getEnvironment(), block.getBiome());
        if (value > 0) {
            int max = resource.getMaxDeviation();
            if (max <= 0) {
                throw new IllegalStateException("GEO Resource \"" + resource.getKey() + "\" was misconfigured! getMaxDeviation() must return a value higher than zero!");
            }
            value += ThreadLocalRandom.current().nextInt(max);
        }
        GEOResourceGenerationEvent event = new GEOResourceGenerationEvent(world, block.getBiome(), x, z, resource, value);
        Bukkit.getPluginManager().callEvent((Event)event);
        value = event.getValue();
        this.setSupplies(resource, world, x, z, value);
        return value;
    }

    public void scan(@Nonnull Player p, @Nonnull Block block, int page) {
        if (SlimefunPlugin.getGPSNetwork().getNetworkComplexity(p.getUniqueId()) < 600) {
            SlimefunPlugin.getLocalization().sendMessages((CommandSender)p, "gps.insufficient-complexity", true, msg -> msg.replace("%complexity%", "600"));
            return;
        }
        int x = block.getX() >> 4;
        int z = block.getZ() >> 4;
        String title = "&4" + SlimefunPlugin.getLocalization().getResourceString(p, "tooltips.results");
        ChestMenu menu = new ChestMenu(title);
        for (int slot2 : this.backgroundSlots) {
            menu.addItem(slot2, ChestMenuUtils.getBackground(), ChestMenuUtils.getEmptyClickHandler());
        }
        menu.addItem(4, new CustomItem(HeadTexture.MINECRAFT_CHUNK.getAsItemStack(), ChatColor.YELLOW + SlimefunPlugin.getLocalization().getResourceString(p, "tooltips.chunk"), "", "&8\u21e8 &7" + SlimefunPlugin.getLocalization().getResourceString(p, "tooltips.world") + ": " + block.getWorld().getName(), "&8\u21e8 &7X: " + x + " Z: " + z), ChestMenuUtils.getEmptyClickHandler());
        ArrayList resources = new ArrayList(SlimefunPlugin.getRegistry().getGEOResources().values());
        resources.sort(Comparator.comparing(a -> a.getName(p).toLowerCase(Locale.ROOT)));
        int index = 10;
        int pages = (resources.size() - 1) / 36 + 1;
        for (int i = page * 28; i < resources.size() && i < (page + 1) * 28; ++i) {
            GEOResource resource = (GEOResource)resources.get(i);
            OptionalInt optional = this.getSupplies(resource, block.getWorld(), x, z);
            int supplies = optional.isPresent() ? optional.getAsInt() : this.generate(resource, block.getWorld(), x, z);
            String suffix = SlimefunPlugin.getLocalization().getResourceString(p, supplies == 1 ? "tooltips.unit" : "tooltips.units");
            CustomItem item2 = new CustomItem(resource.getItem(), "&f" + resource.getName(p), "&8\u21e8 &e" + supplies + ' ' + suffix);
            if (supplies > 1) {
                item2.setAmount(supplies > item2.getMaxStackSize() ? item2.getMaxStackSize() : supplies);
            }
            menu.addItem(index, item2, ChestMenuUtils.getEmptyClickHandler());
            if (++index % 9 != 8) continue;
            index += 2;
        }
        menu.addItem(47, ChestMenuUtils.getPreviousButton(p, page + 1, pages));
        menu.addMenuClickHandler(47, (pl, slot, item, action) -> {
            if (page > 0) {
                this.scan(pl, block, page - 1);
            }
            return false;
        });
        menu.addItem(51, ChestMenuUtils.getNextButton(p, page + 1, pages));
        menu.addMenuClickHandler(51, (pl, slot, item, action) -> {
            if (page + 1 < pages) {
                this.scan(pl, block, page + 1);
            }
            return false;
        });
        menu.open(p);
    }
}

