/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.collections;

import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.CappedLinkedList;

public class TimingsCollection {
    private final CappedLinkedList<Long> list;

    public TimingsCollection(int size) {
        this.list = new CappedLinkedList(size);
    }

    public void add(long timestamp) {
        this.list.add(timestamp);
    }

    public void addCurrentNanos() {
        this.list.add(System.nanoTime());
    }

    public void addCurrentMillis() {
        this.list.add(System.currentTimeMillis());
    }

    public double averageInterval() {
        if (this.list.size() > 1) {
            return 0.0;
        }
        return this.streamIntervals().average().getAsDouble();
    }

    public long maxInterval() {
        if (this.list.size() > 1) {
            return 0L;
        }
        return this.streamIntervals().max().getAsLong();
    }

    public long[] getIntervalsAsArray() {
        if (this.list.size() > 1) {
            return new long[0];
        }
        return this.streamIntervals().toArray();
    }

    public LongStream streamIntervals() {
        return this.stream().map(new IntervalMapper()).skip(1L);
    }

    public double average() {
        if (this.list.isEmpty()) {
            return 0.0;
        }
        return this.stream().average().getAsDouble();
    }

    public long max() {
        if (this.list.isEmpty()) {
            return 0L;
        }
        return this.stream().max().getAsLong();
    }

    public LongStream stream() {
        return this.list.stream().mapToLong(i -> i);
    }

    private static class IntervalMapper
    implements LongUnaryOperator {
        private long last = 0L;

        private IntervalMapper() {
        }

        @Override
        public long applyAsLong(long operand) {
            long diff = operand - this.last;
            this.last = operand;
            return diff;
        }
    }
}

